package gov.va.med.scheduling.dto;

import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;

/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
@ExternalizedBean(type=DefaultExternalizer.class)
public class Clinic {
	/**
	 * 
	 */
	private String id; 	
	/**
	 * 
	 */
	private Division division;
	/**
	 *
	 */
	private Facility facility;
	/**
	 *
	 */
	private String name;
	/**
	 *
	 */
	private String stopCode;
	/**
	 * 
	 */
	private String creditStopCode;
	/**
	 * 
	 */
	private String abbreviation;
	/**
	 * 
	 */
	private ServiceSection service;
	/**
	 * 
	 */
	private String specialty;
	/**
	 * 
	 */
	private Phone phone;
	/**
	 * 
	 */
	private Provider provider;
	/**
	 * 
	 */
	private String nonCount;
	/**
	 * 
	 */
	private Integer appointmentLength;	
	/**
	 * 
	 */
	private String timezone;
	/**
	 * @return the timezone
	 */
	public String getTimezone() {
		return timezone;
	}
	/**
	 * @param timezone the timezone to set
	 */
	public void setTimezone(String timezone) {
		this.timezone = timezone;
	}
	/**
	 * 
	 */
	private boolean teleHealthSupported;		
	/**
	 * @return the teleHealthSupported
	 */
	public boolean isTeleHealthSupported() {
		return teleHealthSupported;
	}
	/**
	 * @param teleHealthSupported the teleHealthSupported to set
	 */
	public void setTeleHealthSupported(boolean teleHealthSupported) {
		this.teleHealthSupported = teleHealthSupported;
	}
	/**
	 * @return the appointmentLength
	 */
	public Integer getAppointmentLength() {
		return appointmentLength;
	}
	/**
	 * @param appointmentLength the appointmentLength to set
	 */
	public void setAppointmentLength(Integer appointmentLength) {
		this.appointmentLength = appointmentLength;
	}
	/**
	 * @return the division
	 */
	public Division getDivision() {
		return division;
	}
	/**
	 * @param division the division to set
	 */
	public void setDivision(Division division) {
		this.division = division;
	}
	/**
	 * @return the creditStopCode
	 */
	public String getCreditStopCode() {
		return creditStopCode;
	}
	/**
	 * @param creditStopCode the creditStopCode to set
	 */
	public void setCreditStopCode(String creditStopCode) {
		this.creditStopCode = creditStopCode;
	}
	/**
	 * @return the phone
	 */
	public Phone getPhone() {
		return phone;
	}
	/**
	 * @param phone the phone to set
	 */
	public void setPhone(Phone phone) {
		this.phone = phone;
	}
	/**
	 * @return the provider
	 */
	public Provider getProvider() {
		return provider;
	}
	/**
	 * @param provider the provider to set
	 */
	public void setProvider(Provider provider) {
		this.provider = provider;
	}
	/**
	 * @return the nonCount
	 */
	public String getNonCount() {
		return nonCount;
	}
	/**
	 * @param nonCount the nonCount to set
	 */
	public void setNonCount(String nonCount) {
		this.nonCount = nonCount;
	}
	/**
	 * 
	 */
	private String pictureLink = "images/clinics/"+getId()+".jpg";	
	/**
	 * @return the pictureLink
	 */
	public String getPictureLink() {
		return pictureLink;
	}
	/**
	 * @param pictureLink the pictureLink to set
	 */
	public void setPictureLink(String pictureLink) {
		this.pictureLink = pictureLink;
	}
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}	
	/**
	 * @return the facility
	 */
	public Facility getFacility() {
		return facility;
	}
	/**
	 * @param facility the facility to set
	 */
	public void setFacility(Facility facility) {
		this.facility = facility;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the stopCode
	 */
	public String getStopCode() {
		return stopCode;
	}
	/**
	 * @param stopCode the stopCode to set
	 */
	public void setStopCode(String stopCode) {
		this.stopCode = stopCode;
	}
	/**
	 * @return the abbreviation
	 */
	public String getAbbreviation() {
		return abbreviation;
	}
	/**
	 * @param abbreviation the abbreviation to set
	 */
	public void setAbbreviation(String abbreviation) {
		this.abbreviation = abbreviation;
	}
	/**
	 * @return the service
	 */
	public ServiceSection getService() {
		return service;
	}
	/**
	 * @param service the service to set
	 */
	public void setService(ServiceSection service) {
		this.service = service;
	}
	/**
	 * @return the specialty
	 */
	public String getSpecialty() {
		return specialty;
	}
	/**
	 * @param specialty the specialty to set
	 */
	public void setSpecialty(String specialty) {
		this.specialty = specialty;
	}	
}
