package gov.va.med.scheduling.dto;

import gov.va.med.scheduling.infra.GlobalFunctions;

import java.util.List;

import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;

/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
@ExternalizedBean(type=DefaultExternalizer.class)
public class AppointmentCategory {
	/**
	 *
	 */
	private String id;
	/**
	 *
	 */
	private String name;
	/**
	 * 
	 */
	private String description;
	/**
	 * 
	 */
	private String pictureLink;	
	/**
	 * 
	 */
	private List<AppointmentReason> appointmentReasons;	
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}	
	/**
	 * @return the appointmentReasons
	 */
	public List<AppointmentReason> getAppointmentReasons() {
		return appointmentReasons;
	}
	/**
	 * @param appointmentReasons the appointmentReasons to set
	 */
	public void setAppointmentReasons(List<AppointmentReason> appointmentReasons) {
		this.appointmentReasons = appointmentReasons;
	}	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
		if(GlobalFunctions.isNullOrEmpty(description) && !GlobalFunctions.isNullOrEmpty(name)){			
			description = name.substring(0,1)+name.substring(1,name.length()).toLowerCase();			
		}		
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		if(GlobalFunctions.isNullOrEmpty(description) && !GlobalFunctions.isNullOrEmpty(name)){			
			description = name.substring(0,1)+name.substring(1,name.length()).toLowerCase();			
		}
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return the pictureLink
	 */
	public String getPictureLink() {
		return pictureLink;
	}
	/**
	 * @param pictureLink the pictureLink to set
	 */
	public void setPictureLink(String pictureLink) {
		this.pictureLink = pictureLink;
	}	
}
