package gov.va.med.scheduling.view.components.slotselector
{
	import flash.events.MouseEvent;
	
	import mx.collections.ArrayCollection;
	import mx.core.ClassFactory;
	
	import spark.collections.Sort;
	import spark.components.HGroup;
	import spark.components.Image;
	import spark.components.List;
	import spark.layouts.ColumnAlign;
	import spark.layouts.TileLayout;
	import spark.layouts.TileOrientation;
	
	import gov.va.med.scheduling.dto.Appointment;
	import gov.va.med.scheduling.model.SlotsForDay;
	import gov.va.med.scheduling.view.components.calendar.interfaces.ICalendarItem;
	
	public class SlotSelector extends HGroup
	{
		[Embed(source="/assets/images/slot_arrows/slotArrowLeft.png")]
		private var slotArrowLeft:Class;
		
		[Embed(source="/assets/images/slot_arrows/slotArrowRight.png")]
		private var slotArrowRight:Class;
		
		public function SlotSelector()
		{
			super();
		}
		
		private var grid:List;
		private var leftArrow:Image;
		private var rightArrow:Image;
		
		private var _dataProvider:ArrayCollection;
		
		public function get dataProvider():ArrayCollection
		{
			return _dataProvider;
		}

		public function set dataProvider(value:ArrayCollection):void
		{
			dataDirty = viewDirty = value != _dataProvider;
			
			_dataProvider = value;
			
			dateFrom = null;
			dateTo = null;
			
			invalidateProperties();
			invalidateDisplayList();
		}

		private var dateFrom:Date;
		private var dateTo:Date;
		
		private var dataDirty:Boolean;
		private var viewDirty:Boolean;
		
		private var page:int;
		private var pageSize:int = 4;
		
		override protected function createChildren():void
		{
			super.createChildren();
			
			//	TODO: add left navigation arrow
			//	TODO: add right navigation arrow
			
			leftArrow = new Image();
			leftArrow.source = slotArrowLeft;
			leftArrow.buttonMode = true;
			leftArrow.addEventListener(MouseEvent.CLICK,onLeftArrowClick);
			addElement(leftArrow);
			
			var layout:TileLayout = new TileLayout();
			layout.horizontalGap = 12;
			layout.orientation = TileOrientation.COLUMNS;
			layout.columnAlign = ColumnAlign.LEFT;
			
			grid = new List();
			grid.layout = layout;
			grid.allowMultipleSelection = false;
			grid.useVirtualLayout = false;
			grid.itemRenderer = new ClassFactory( SlotsForDayRenderer );
			grid.setStyle('borderAlpha', 0);
			grid.setStyle('contentBackgroundAlpha', 0);
			grid.setStyle('horizontalScrollPolicy', 'off');
			addElement(grid);
			
			rightArrow = new Image();
			rightArrow.source = slotArrowRight;
			rightArrow.buttonMode = true;
			rightArrow.addEventListener(MouseEvent.CLICK,onRightArrowClick);
			addElement(rightArrow);
		}
		
		override protected function commitProperties():void
		{
			super.commitProperties();
			
			(grid.layout as TileLayout).requestedColumnCount = pageSize;
			
			if( dataDirty )
			{
				var sort:Sort = new Sort();
				sort.compareFunction = sortByDate;
				
				if( dataProvider )
				{
					dataProvider.sort = sort;
					dataProvider.refresh();
				}
				
				if( dateFrom == null
					&& dataProvider )
				{
					var date:Date = (dataProvider.getItemAt(0) as Appointment).startDateTime;
					
					dateFrom = new Date( date.fullYear, date.month, date.date );
					
					dateTo = new Date();
					dateTo.date += 3;
				}
				
				page = 0;
				
				dataDirty = false;
			}
			
			if( viewDirty 
				&& dateFrom )
			{
				var __dataProvider:ArrayCollection = new ArrayCollection();
				
				var startDate:Date = new Date();
				startDate.time = dateFrom.time;
				startDate.date += (page * pageSize);
				
				var dateCursor:Date = new Date();
				dateCursor.setTime( startDate.time );
				
				for(var i:int=0;i<pageSize;i++)
				{
					var itemsForDate:ArrayCollection = getItemsForDate( dateCursor );
					
					__dataProvider.addItem( new SlotsForDay( new Date(dateCursor.fullYear,dateCursor.month,dateCursor.date), itemsForDate ) );
					
					dateCursor.date += 1;
				}
				
				grid.dataProvider = __dataProvider;
				
				viewDirty = false;
			}
			
			if( dataProvider 
				&& dataProvider.length )
			{
				leftArrow.visible = page > 0;
				rightArrow.visible = page < Math.floor( dataProvider.length / pageSize );
			}
			else
			{
				leftArrow.visible = false;
				rightArrow.visible = false;
			}
		}
		
		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
			
			leftArrow.y = rightArrow.y = 40;
			
			grid.width = unscaledWidth - leftArrow.width - rightArrow.width - gap*2;
			
			var layout:TileLayout = (grid.layout as TileLayout);
			
			layout.columnWidth = (grid.width - ((layout.columnCount-1) * layout.horizontalGap)) / layout.columnCount;
		}
		
		private function getItemsForDate( date:Date ):ArrayCollection
		{
			var items:ArrayCollection = new ArrayCollection();
			
			if( !dataProvider ) return items;
			
			for(var i:int=0;i<dataProvider.length;i++)
			{
				var item:Appointment = dataProvider.getItemAt(i) as Appointment;
				
				var itemDate:Date = item.startDateTime as Date;
				
				var match:Boolean = date.fullYear == itemDate.fullYear
					&& date.month == itemDate.month
					&& date.date == itemDate.date;
				
				if( match ) items.addItem( item );
			}
			
			return items;
		}
		
		private function navigate(direction:int):void
		{
			page += direction;
			
			viewDirty = true;
			
			invalidateProperties();
		}
		
		private function onLeftArrowClick(event:MouseEvent):void
		{
			navigate(-1);
		}
		
		private function onRightArrowClick(event:MouseEvent):void
		{
			navigate(1);
		}
		
		private function sortByDate(item1:ICalendarItem, item2:ICalendarItem, fields:Array = null):int
		{
			if( item1.from.time < item2.from.time ) return -1;
			if( item1.from.time > item2.from.time ) return 1;
			
			return 0;
		}
	}
}