package gov.va.med.scheduling.view.components.calendar.multicalendar
{
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.events.MouseEvent;
	
	import mx.charts.AxisRenderer;
	import mx.charts.ColumnChart;
	import mx.collections.ArrayCollection;
	import mx.core.IUITextField;
	import mx.core.UIFTETextField;
	import mx.core.UITextField;
	import mx.events.CollectionEvent;
	
	import gov.va.med.scheduling.util.DateUtil;
	import gov.va.med.scheduling.view.components.calendar.CalendarEvent;
	import gov.va.med.scheduling.view.components.calendar.interfaces.IScheduleOwner;
	
	public class WeeklyCustomChartLabel extends CustomChartLabel
	{	
		private const LABEL_WIDTH:uint = 16;

		private var dirty:Boolean;
		
		private var labels:Vector.<IUITextField>;
		
		public function WeeklyCustomChartLabel()
		{
			super();
			
			buttonMode = true;
		}
		
		override protected function commitProperties():void
		{
			super.commitProperties();
			
			if( dirty )
			{
				var today:Date = new Date();
				
				if( data
					&& data.value is Date
					&& today.fullYear == (data.value as Date).fullYear
					&& today.month == (data.value as Date).month
					&& today.date == (data.value as Date).date )
				{
					(getChildAt(0) as IUITextField).styleName = "todayLabel";
				}
				
				while(numChildren>1) removeChildAt(1);
				
				var _label:IUITextField
				
				labels = new Vector.<IUITextField>;
				
				var scheduleOwners:ArrayCollection = getSchedulerOwners();
				
				if( scheduleOwners )
				{
					for(var i:int=0;i<scheduleOwners.length;i++)
					{
						var p:IScheduleOwner = IScheduleOwner(scheduleOwners[i]);
						
						_label = IUITextField(createInFontContext(UITextField));
						_label.multiline = false;
						_label.selectable = false;
						_label.autoSize = "left";
						_label.styleName = "blue11Bold";
						_label.text = p[labelProperty];
						_label.rotation = -90;
						_label.addEventListener( MouseEvent.CLICK, onLabelClick );
						addChild( DisplayObject(_label) );
						
						labels.push( _label );
					}
					
					for(i=0;i<labels.length;i++)
					{
						_label = labels[i];
						
						_label.x = (width / labels.length - LABEL_WIDTH) / 2 + i*(width / labels.length);
						_label.y = height - 2;
					}
				}
				
				dirty = false;
			}
		}
		
		override protected function updateDisplayList(w:Number, h:Number):void 
		{
			super.updateDisplayList(w, h);
			
			var _label:IUITextField = IUITextField( getChildAt(0) );
			_label.x = w/2-_label.textWidth/2;
			
			var y:int = _label.height + 5;
			
			var g:Graphics = graphics; 
			g.clear();  
			
			g.lineStyle(0,0x86888A);
			g.beginFill(0x4D4D4D,1);
			g.drawRect(0,y,w,h - y);
			g.endFill();
		}
		
		override protected function measure():void
		{
			super.measure();
			
			measuredHeight = 110;
		}
		
		override public function set data(value:Object):void
		{
			super.data = value;
			
			var date:Date = new Date();
			date.setTime( Date.parse( value.value ) );
			
			var scheduleOwners:ArrayCollection = getSchedulerOwners();
			
			if( scheduleOwners != null )
				scheduleOwners.addEventListener(CollectionEvent.COLLECTION_CHANGE, onScheduleOwnersChange );
			
			onScheduleOwnersChange();
		}
		
		override protected function onLabelClick( event:MouseEvent ):void
		{
			event.stopImmediatePropagation();
			
			var target:UIFTETextField = event.currentTarget as UIFTETextField;
			
			var scheduleOwners:ArrayCollection = getSchedulerOwners();
			
			for(var i:int=0;i<scheduleOwners.length;i++)
			{
				var scheduleOwner:IScheduleOwner = scheduleOwners.getItemAt(i) as IScheduleOwner;
				
				if( scheduleOwner[labelProperty] == target.text )
				{
					var evt:CalendarEvent = new CalendarEvent( CalendarEvent.SHOW_OWNER, true );
					evt.owner = scheduleOwner;
					dispatchEvent( evt );
					
					break;
				}
			}
		}
		
		override protected function getSchedulerOwners():ArrayCollection
		{
			if( parent is AxisRenderer
				&& AxisRenderer(parent).parent is ColumnChart
				&& ColumnChart(AxisRenderer(parent).parent).parent is MultiCalendar )
			{
				return MultiCalendar(parent.parent.parent).scheduleOwners;
			}
			
			return null;
		}
		
		private function onScheduleOwnersChange(event:CollectionEvent=null):void
		{
			dirty = true;
			
			invalidateProperties();
		}
	}
}
