package gov.va.med.scheduling.view.components.calendar.multicalendar
{
	import mx.charts.AxisRenderer;
	import mx.charts.CategoryAxis;
	import mx.charts.ChartItem;
	import mx.charts.ColumnChart;
	import mx.charts.LinearAxis;
	import mx.charts.chartClasses.AxisBase;
	import mx.charts.chartClasses.IAxis;
	import mx.charts.chartClasses.Series;
	import mx.charts.series.ColumnSeries;
	import mx.charts.series.items.ColumnSeriesItem;
	import mx.collections.ArrayCollection;
	import mx.controls.Label;
	import mx.core.ClassFactory;
	import mx.core.IFactory;
	import mx.graphics.GradientEntry;
	import mx.graphics.IFill;
	import mx.graphics.LinearGradient;
	import mx.graphics.SolidColorStroke;
	
	import spark.components.VGroup;
	import spark.formatters.DateTimeFormatter;
	
	import gov.va.med.scheduling.view.components.calendar.interfaces.ICalendarItem;
	import gov.va.med.scheduling.view.components.calendar.interfaces.IScheduleOwner;
	
	[Event(name="showOwner", type="gov.va.med.scheduling.view.components.calendar.CalendarEvent")]
	[Event(name="chartClick", type="flash.events.MouseEvent")]
	[Event(name="change", type="mx.charts.events.ChartItemEvent")]
	public class MultiCalendar extends VGroup
	{
		public static const MODE_DAY:String = "day";
		public static const MODE_WEEK:String = "week";
		
		public static const SECOND:Number = 1000;
		public static const MINUTE:Number = SECOND * 60;
		public static const HOUR:Number = MINUTE * 60;
		public static const DAY:Number = HOUR * 24;
		public static const WEEK:Number = DAY * 7;
		public static const MONTH:Number = DAY * 30.4368;
		public static const YEAR:Number = MONTH * 12;
		
		public function MultiCalendar()
		{
			super();
			
			headerFormatter = new DateTimeFormatter();
			headerFormatter.dateTimePattern = _dateTimePattern = "EEEE";
			
			sidebarFormatter = new DateTimeFormatter();
			sidebarFormatter.dateTimePattern = _timePattern = "ha";
			
			model = MultiCalendarModel.getInstance();
			model.scheduleOwnerDisplayProperty = "lastName";
			
			hourFrom = 0;
			hourTo = 24;
		}
		
		public var chart:ColumnChart;
		
		private var headerLabel:Label;
		
		private var dateStart:Date;
		private var dateEnd:Date;
		private var hAxis:CategoryAxis;
		private var vAxis:LinearAxis;
		private var hRenderer:AxisRenderer;
		private var vRenderer:AxisRenderer;
		private var column:ColumnSeries;
		private var model:MultiCalendarModel;
		
		//--------------------------------------------------------------------------
		//
		//  Variables
		//
		//--------------------------------------------------------------------------
		
		private var headerFormatter:DateTimeFormatter;
		private var sidebarFormatter:DateTimeFormatter;
		
		//--------------------------------------------------------------------------
		//
		//  Overridden methods: UIComponent
		//
		//--------------------------------------------------------------------------
		override protected function createChildren():void
		{
			super.createChildren();
			
			headerLabel = new Label();
			addElement(headerLabel);
			
			chart = new ColumnChart();
			chart.selectionMode = "single";
			chart.showDataTips = false;
			chart.dragEnabled = true;
			chart.dropEnabled = true;
			chart.setStyle("columnWidthRatio",1);
			chart.setStyle("itemRollOverColor","0xFF931E");
			chart.setStyle("itemSelectionColor","0xFF931E");
			addElement(chart);
			
			vAxis = new LinearAxis();
			vAxis.labelFunction = getTimeLabel;
			vAxis.interval = HOUR;
			vAxis.minorInterval = HOUR/4;
			vAxis.direction = "inverted";
			vAxis.alignLabelsToInterval = false;
			chart.verticalAxis = vAxis;
			
			vRenderer = new AxisRenderer();
			vRenderer.axis = vAxis;
			
			chart.verticalAxisRenderers = [vRenderer];
		}
		
		override protected function commitProperties():void
		{
			if( dataDirty )
			{
				chart.dataProvider = dataProvider;
				
				if( !selectedDate ) return;
				
				headerFormatter.dateTimePattern = dateTimePattern;
				sidebarFormatter.dateTimePattern = timePattern;
				
				hRenderer = new AxisRenderer();
				hRenderer.placement = "top";
				
				var columnSeries:Array = [];
				
				if( mode == MODE_DAY )
				{
					dateStart = new Date( selectedDate.fullYear, selectedDate.month, selectedDate.date );
					
					dateEnd = new Date();
					dateEnd.time = dateStart.time;
					dateEnd.date += 1;
					
					hAxis = new CategoryAxis();
					CategoryAxis(hAxis).dataProvider = _scheduleOwners;
					CategoryAxis(hAxis).dataFunction = horizontalAxisCategoryFunction;
					CategoryAxis(hAxis).ticksBetweenLabels = true;
					hRenderer.axis = hAxis;
					
					column = new ColumnSeries();
					column.id = "appointmentTime";
					column.dataFunction = valueFunctionDay;
					column.dataProvider = getCalendarItemsForOwner( null, dateStart );
					column.minField = 'anything';
					column.fillFunction = getFill;
					column.labelFunction = labelFunctionDay;
					
					chart.horizontalAxis = hAxis;
					chart.horizontalAxisRenderers = [hRenderer];
					
					columnSeries = [column];
					
					hRenderer.labelRenderer = new ClassFactory(DailyCustomChartLabel);
					
					chart.series = columnSeries;
				}
				else if( mode == MODE_WEEK )
				{
					dateStart = new Date( selectedDate.fullYear, selectedDate.month, selectedDate.date );
					dateStart.setTime( dateStart.time - (DAY * dateStart.day) );
					
					dateEnd = new Date();
					dateEnd.setTime( dateStart.time + (WEEK - DAY) );
					
					daysInRange = new ArrayCollection();
					
					for(var i:int=0;i<7;i++)
					{
						var day:Date = new Date( dateStart.fullYear, dateStart.month, dateStart.date );
						day.time += (DAY * i);
						daysInRange.addItem( day );
					}
					
					if( _scheduleOwners )
					{
						for(i=0;i<_scheduleOwners.length;i++)
						{
							var owner:IScheduleOwner = IScheduleOwner( _scheduleOwners.getItemAt(i) );
							
							column = new ColumnSeries();
							column.id = owner.id.toString();
							column.labelFunction = labelFunctionWeek;
							column.dataFunction = valueFunctionWeek;
							column.minField = 'anything';
							column.fillFunction = getFill;
							column.dataProvider = getCalendarItemsForOwner( owner.id );
							
							columnSeries.push( column );
						}
					}
					
					hAxis = new CategoryAxis();
					CategoryAxis(hAxis).dataProvider = daysInRange;
					CategoryAxis(hAxis).dataFunction = horizontalAxisCategoryFunction;
					CategoryAxis(hAxis).ticksBetweenLabels = true;
					CategoryAxis(hAxis).labelFunction = getDateLabel;
					
					hRenderer.labelRenderer = new ClassFactory(WeeklyCustomChartLabel);
					hRenderer.axis = hAxis;
					
					chart.horizontalAxis = hAxis;
					chart.horizontalAxisRenderers = [hRenderer];
				}

				var axisStart:Date = new Date( dateStart.fullYear, dateStart.month, dateStart.date, this.hourFrom, 0, 0 );
				
				vAxis.minimum = axisStart.time;
				
				axisStart.time += HOUR * (hourTo-hourFrom);
				
				vAxis.maximum = axisStart.time;
				
				chart.series = columnSeries;
				
				stylesDirty = true;
			}
			
			if( stylesDirty )
			{
				if( hRenderer )
				{
					hRenderer.styleName = (mode == MODE_DAY) ? headerStyle : headerStyleWeek;
					
					hRenderer.setStyle('axisStroke', hAxisStroke);
					hRenderer.setStyle('showLine', true);
					hRenderer.setStyle('tickPlacement', 'none');
					hRenderer.setStyle('minorTickPlacement', 'none');
					hRenderer.setStyle('labelAlign', 'center');
					hRenderer.setStyle('labelGap',-1);
				}
				
				if( vRenderer )
				{
					vRenderer.styleName = labelStyle;
					
					vRenderer.setStyle('showLine', false);
					vRenderer.setStyle('tickPlacement', 'none');
					vRenderer.setStyle('minorTickPlacement', 'none');
					vRenderer.setStyle('minorTickLength', 650);
					vRenderer.setStyle('labelAlign', 'bottom');
					vRenderer.setStyle('labelGap',0);
				}
				
				if( column )
				{
					column.styleName = labelStyle;
					
					column.setStyle('labelPosition','inside');
					column.setStyle('labelAlign','top');
					column.setStyle('stroke',columnStroke);
				}
				
				if( headerLabel )
				{
					var today:Date = new Date();
					
					headerLabel.styleName = selectedDate.fullYear == today.fullYear && selectedDate.month == today.month && selectedDate.date == today.date ? labelStyleSelected : labelStyle;
				}
				
				chart.backgroundElements = backgroundElements;
				
				for(i=0;i<chart.series.length;i++)
				{
					(chart.series[i] as ColumnSeries).setStyle("itemRenderer",itemRenderer?itemRenderer:null);
				}

				stylesDirty = false;
			}
			
			headerLabel.visible = headerLabel.includeInLayout = mode == MODE_DAY;
			
			super.commitProperties();
		}
		
		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth,unscaledHeight);
			
			var y:int = 0;
			
			if( mode == MODE_DAY )
			{
				headerLabel.text = headerFormatter.format(selectedDate);
				headerLabel.x = unscaledWidth/2 - headerLabel.width/2 + 50;		//50 pixels to compensate for left margin
				
				y += headerLabel.height + 5;
			}
			
			chart.width = unscaledWidth;
			chart.height = unscaledHeight - y;
			chart.y = y;
		}
		
		private function getCalendarItemsForOwner( id:String = null, date:Date = null ):ArrayCollection
		{
			var results:ArrayCollection = new ArrayCollection();
			
			for each(var item:ICalendarItem in dataProvider)
			{
				var valid:Boolean = true;
				
				if( customItemValidityFuntion != null )
				{
					if( !customItemValidityFuntion(item,id,date) )
						valid = false;
				}
				else
				{
					if( id != null 
						&& item.owner.id != id ) 
					{
						valid = false;
					}
					
					if( date != null 
						&& ( item.from.fullYear != date.fullYear 
							|| item.from.month != date.month
							|| item.from.date != date.date ) )
					{
						valid = false;
					}
				}
				
				if( valid ) results.addItem( item );
			}
			
			return results;
		}
		
		private function getDateLabel(item:Date, prevValue:Object, axis:CategoryAxis, categoryItem:Object):String 
		{
			return headerFormatter.format(item);
		}
		
		private function getTimeLabel(item:Number, prevValue:Object, axis:IAxis):String 
		{
			var date:Date = new Date();
			date.time = item;
			
			return (date.getHours() == hourFrom && timeZone ? timeZone+" " : "" )+sidebarFormatter.format(date);
		}
		
		private function getFill( item:ColumnSeriesItem, rotation:int = 0 ):IFill
		{
			if( customFillFunction != null ) return customFillFunction( item, rotation );
			
			var fill:LinearGradient = new LinearGradient();
			fill.entries = [ new GradientEntry( 0xCCCCCC ) ];
			
			return fill;
		}
		
		private function labelFunctionWeek(element:ChartItem, series:Series):String
		{
			var item:ICalendarItem = ICalendarItem( element.item );
			
			if( customLabelFunctionWeek != null ) return customLabelFunctionWeek( item );
			
			return item.owner ? item.owner.lastName : "";
		}
		
		private function labelFunctionDay(element:ChartItem, series:Series):String
		{
			var item:ICalendarItem = ICalendarItem( element.item );
			
			if( customLabelFunctionDay != null ) return customLabelFunctionDay( item );
			
			return (item.owner ? item.owner.lastName + "\n" : "") + item.description;
		}
		
		public function valueFunctionDay(series:Series, item:ICalendarItem, fieldName:String):Object 
		{
			var from:Date = new Date();
			from.time = item.from.time;
			
			var to:Date = new Date();
			to.time = item.to.time;
			
			if( customItemMassageDateFunction != null ) customItemMassageDateFunction( item, from, to, dateStart, mode );
			
			if( fieldName == "xValue" 
				&& series.id=="appointmentTime" )
				return( item.owner[model.scheduleOwnerDisplayProperty] );
			else if( fieldName == "yValue" 
				&& series.id=="appointmentTime" )
				return( from.time );
			else if( fieldName == "minValue" 
				&& series.id=="appointmentTime" )
				return( to.time );
				
			else
				return null;
		}
		
		public function valueFunctionWeek(series:Series, item:ICalendarItem, fieldName:String):Object 
		{
			var date:Date = new Date( vAxis.minimum );
			var time:Number;
			
			var from:Date = new Date();
			from.time = item.from.time;
			
			var to:Date = new Date();
			to.time = item.to.time;
			
			if( fieldName == "xValue" )
				return( new Date( from.fullYear, from.month, from.date ) );
			else if( fieldName == "yValue" )
			{
				time = from.time - (DAY * (from.date - date.date));
				return time;
			}
			else if( fieldName == "minValue"  )
			{
				time = to.time - (DAY * (from.date - date.date));
				return time;
			}
			else
				return null;
		}
		
		private function horizontalAxisCategoryFunction(axis:AxisBase, item:*):Object 
		{
			if( item is Date ) 
				return item;
			else if( item is IScheduleOwner ) 
				return IScheduleOwner(item).lastName;
			else if( item is ICalendarItem ) 
				return ICalendarItem(item).id;
			
			//return( Appointment(item).patient.id );
			return null;
		}
		
		//--------------------------------------------------------------------------
		//
		//  Properties
		//
		//--------------------------------------------------------------------------

		//----------------------------------
		//  backgroundElements
		//---------------------------------- 
		
		private var _backgroundElements:Array;

		public function get backgroundElements():Array
		{
			return _backgroundElements;
		}

		public function set backgroundElements(value:Array):void
		{
			stylesDirty = true;
			
			_backgroundElements = value;
			
			invalidateProperties();
		}

		//----------------------------------
		//  columnStroke
		//---------------------------------- 
		
		private var _columnStroke:SolidColorStroke;

		public function get columnStroke():SolidColorStroke
		{
			return _columnStroke;
		}

		public function set columnStroke(value:SolidColorStroke):void
		{
			stylesDirty = true;
			
			_columnStroke = value;
			
			invalidateProperties();
		}
		
		public var customLabelFunctionDay:Function;
		public var customLabelFunctionWeek:Function;
		public var customFillFunction:Function;
		public var customItemValidityFuntion:Function;
		public var customItemMassageDateFunction:Function;
		
		//----------------------------------
		//  dataProvider
		//---------------------------------- 

		private var _dataProvider:Object;
		
		public function get dataProvider():Object
		{
			return _dataProvider;
		}
		
		public function set dataProvider(value:Object):void
		{
			dataDirty = stylesDirty = true;
			
			_dataProvider = value;
			
			invalidateProperties();
		}
		
		//----------------------------------
		//  dataDirty
		//---------------------------------- 
		
		public var dataDirty:Boolean;
		
		//----------------------------------
		//  dataDirty
		//---------------------------------- 
		
		public var dateDirty:Boolean;
		
		//----------------------------------
		//  dateTimePattern
		//---------------------------------- 
		
		private var _dateTimePattern:String;
		
		public function get dateTimePattern():String
		{
			return _dateTimePattern;
		}
		
		public function set dateTimePattern(value:String):void
		{
			dateDirty = true;
			
			_dateTimePattern = value;
			
			invalidateProperties();
			invalidateDisplayList();
		}
		
		//----------------------------------
		//  daysInRange
		//---------------------------------- 
		
		private var daysInRange:ArrayCollection;

		private var _itemRenderer:IFactory;

		public function get itemRenderer():IFactory
		{
			return _itemRenderer;
		}
		
		public function set itemRenderer(value:IFactory):void
		{
			dataDirty = true;
			
			_itemRenderer = value;
			
			invalidateProperties();
		}

		private var _labelStyle:String;

		public function get labelStyle():String
		{
			return _labelStyle;
		}

		public function set labelStyle(value:String):void
		{
			stylesDirty = true;
			
			_labelStyle = value;
			
			invalidateProperties();
		}
		
		private var _labelStyleSelected:String;
		
		public function get labelStyleSelected():String
		{
			return _labelStyleSelected;
		}
		
		public function set labelStyleSelected(value:String):void
		{
			stylesDirty = true;
			
			_labelStyleSelected = value;
			
			invalidateProperties();
		}
		
		private var _headerStyle:String;
		
		public function get headerStyle():String
		{
			return _headerStyle;
		}
		
		public function set headerStyle(value:String):void
		{
			stylesDirty = true;
			
			_headerStyle = value;
			
			invalidateProperties();
		}
		
		private var _headerStyleWeek:String;
		
		public function get headerStyleWeek():String
		{
			return _headerStyleWeek;
		}
		
		public function set headerStyleWeek(value:String):void
		{
			stylesDirty = true;
			
			_headerStyleWeek = value;
			
			invalidateProperties();
		}
		
		private var _hourFrom:int;

		public function get hourFrom():int
		{
			return _hourFrom;
		}

		public function set hourFrom(value:int):void
		{
			dataDirty = true;
			
			_hourFrom = value;
			
			invalidateProperties();
		}

		private var _hourTo:int;

		public function get hourTo():int
		{
			return _hourTo;
		}

		public function set hourTo(value:int):void
		{
			dataDirty = true;
			
			_hourTo = value;
			
			invalidateProperties();
		}
		
		//----------------------------------
		//  mode
		//---------------------------------- 
		
		private var _mode:String;
		
		public function get mode():String
		{
			return _mode;
		}
		
		[Bindable]
		public function set mode(value:String):void
		{
			dataDirty = stylesDirty = true;
			
			_mode = value;
			
			invalidateProperties();
			invalidateDisplayList();
		}
		
		//----------------------------------
		//  scheduleOwners
		//---------------------------------- 

		private var _scheduleOwners:ArrayCollection;
		
		public function set scheduleOwners(value:ArrayCollection):void
		{
			dataDirty = stylesDirty = true;
			
			_scheduleOwners = value;
			
			invalidateProperties();
		}
		
		public function get scheduleOwners():ArrayCollection
		{
			return _scheduleOwners;
		}
		
		//----------------------------------
		//  selectedDate
		//---------------------------------- 
		
		private var _selectedDate:Date;
		
		public function get selectedDate():Date
		{
			return _selectedDate;
		}
		
		public function set selectedDate(value:Date):void
		{
			if( _selectedDate == value ) return;
			
			var dirty:Boolean = true;
			
			/*
			if( ( _selectedDate && mode == MODE_MONTH && _selectedDate.fullYear == value.fullYear && _selectedDate.month == value.month )
				|| ( _selectedDate && mode == MODE_WEEK && _selectedDate.fullYear == value.fullYear && _selectedDate.month == value.month && Math.round(_selectedDate.date/7) == Math.round(value.date/7) ) )
			{
				dirty = false;		
			}
			
			
			if( !clickNavigation && !dirty ) return;
			*/
			
			dateDirty = dataDirty = dirty;
			
			_selectedDate = new Date( value.fullYear, value.month, value.date );
			
			invalidateProperties();
			invalidateDisplayList();
		}

		//----------------------------------
		//  stylesDirty
		//---------------------------------- 
		
		public var stylesDirty:Boolean;
		
		//----------------------------------
		//  timePattern
		//---------------------------------- 
		
		private var _timePattern:String;
		
		public function get timePattern():String
		{
			return _timePattern;
		}
		
		public function set timePattern(value:String):void
		{
			dateDirty = true;
			
			_timePattern = value;
			
			invalidateProperties();
			invalidateDisplayList();
		}
		
		//----------------------------------
		//  timeZone
		//---------------------------------- 
		
		private var _timeZone:String;
		
		public function get timeZone():String
		{
			return _timeZone;
		}
		
		public function set timeZone(value:String):void
		{
			dateDirty = true;
			
			_timeZone = value;
			
			invalidateProperties();
		}
		
		//----------------------------------
		//  hAxisStroke
		//---------------------------------- 
		
		private var _hAxisStroke:SolidColorStroke;
		
		public function get hAxisStroke():SolidColorStroke
		{
			return _hAxisStroke;
		}

		public function set hAxisStroke(value:SolidColorStroke):void
		{
			stylesDirty = true;	//	TODO: could be 
			
			_hAxisStroke = value;
			
			invalidateProperties();
		}
	}
}