package gov.va.med.scheduling.view.components.calendar.multicalendar
{
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.events.MouseEvent;
	
	import mx.collections.ArrayCollection;
	import spark.core.SpriteVisualElement;
	
	public class DailyCustomChartLabel extends CustomChartLabel
	{
		private var labelHitArea:SpriteVisualElement;
		
		private var options:ArrayCollection = new ArrayCollection( ['Message All','Cancel All'] );
		
		[Embed(source="/assets/images/smallArrowGray.png")]
		private var iconClass:Class;
		
		public function DailyCustomChartLabel()
		{
			super();
			
			setStyle('paddingLeft',5);
			setStyle('paddingTop',2);
		}
		
		override protected function createChildren():void
		{
			super.createChildren();
			
			labelHitArea = new SpriteVisualElement();
			labelHitArea.buttonMode = true;
			labelHitArea.addEventListener( MouseEvent.CLICK, onLabelClick );
			addChildAt( labelHitArea, 1 );
		}
		
		override protected function updateDisplayList(w:Number, h:Number):void 
		{
			super.updateDisplayList(w, h);
			
			var _label:DisplayObject = getChildAt(0);
			
			_label.x = getStyle('paddingLeft');
			_label.y = getStyle('paddingTop');
			
			labelHitArea.graphics.clear();
			labelHitArea.graphics.beginFill(0x000000,0);
			labelHitArea.graphics.drawRect(_label.x,_label.y,_label.width,_label.height);
			
			var g:Graphics = graphics; 
			g.clear();  
			
			g.lineStyle(0,0x86888A);
			g.beginFill(0x4D4D4D,1);
			g.drawRect(0,0,w,h);
			g.endFill();
		}
	}
}