package gov.va.med.scheduling.view.components.calendar.multicalendar
{
	import flash.events.MouseEvent;
	
	import mx.charts.AxisLabel;
	import mx.charts.AxisRenderer;
	import mx.charts.CategoryAxis;
	import mx.charts.chartClasses.ChartLabel;
	import mx.collections.ArrayCollection;
	
	import gov.va.med.scheduling.view.components.calendar.CalendarEvent;
	import gov.va.med.scheduling.view.components.calendar.interfaces.IScheduleOwner;
	
	public class CustomChartLabel extends ChartLabel
	{
		protected var labelProperty:String;
		
		public function CustomChartLabel()
		{
			super();
			
			labelProperty = MultiCalendarModel.getInstance().scheduleOwnerDisplayProperty;
		}
		
		override protected function measure():void
		{
			super.measure();
			
			var parent:AxisRenderer = AxisRenderer(parent);
			
			measuredHeight = 23;
			measuredWidth = ( ( parent.width - parent.gutters.left + parent.gutters.right ) / CategoryAxis(parent.axis).dataProvider.length) - 6;
		}
		
		protected function onLabelClick( event:MouseEvent ):void
		{
			event.stopImmediatePropagation();
			
			var scheduleOwners:ArrayCollection = getSchedulerOwners();
			
			for(var i:int=0;i<scheduleOwners.length;i++)
			{
				var scheduleOwner:IScheduleOwner = scheduleOwners.getItemAt(i) as IScheduleOwner;
				
				if( scheduleOwner[labelProperty] == AxisLabel(data).value )
				{
					var evt:CalendarEvent = new CalendarEvent( CalendarEvent.SHOW_OWNER, true );
					evt.owner = scheduleOwner;
					dispatchEvent(evt);
					
					break;
				}
			}
		}
		
		protected function getSchedulerOwners():ArrayCollection
		{
			var parent:AxisRenderer = AxisRenderer(parent);
			
			return CategoryAxis(parent.axis).dataProvider as ArrayCollection;
		}
	}
}