package gov.va.med.scheduling.view.components.calendar.multicalendar
{
	import flash.display.CapsStyle;
	import flash.display.Graphics;
	import flash.geom.Rectangle;
	
	import mx.charts.ChartItem;
	import mx.charts.chartClasses.GraphicsUtilities;
	import mx.charts.renderers.BoxItemRenderer;
	import mx.graphics.IFill;
	import mx.graphics.IStroke;
	import mx.graphics.SolidColor;
	import mx.utils.ColorUtil;
	
	import gov.va.med.scheduling.dto.Appointment;
	
	import org.osmf.layout.ScaleMode;
	
	public class CalendarItemRenderer extends BoxItemRenderer
	{
		public var appointment:Appointment;
		
		public function CalendarItemRenderer()
		{
			super();
		}
		
		override public function set data(value:Object):void
		{
			super.data = value;
			
			if( data is ChartItem 
				&& ChartItem(data).item is Appointment )
			{
				appointment = ChartItem(data).item as Appointment;
				
				invalidateProperties();
			}
		}
		
		override protected function updateDisplayList(unscaledWidth:Number,
													  unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
			
			var fill:IFill;
			var state:String = "";
			
			if (data is ChartItem && data.hasOwnProperty('fill'))
			{
				state = data.currentState;
				fill = data.fill;
			}	 	
			else
				fill = GraphicsUtilities.fillFromStyle(getStyle('fill'));
			
			var color:uint;
			var adjustedRadius:Number = 0;
			
			switch (state)
			{
				case ChartItem.FOCUSED:
				case ChartItem.ROLLOVER:
					
					if( appointment && appointment.isPatientAppointment() )
					{
						if (styleManager.isValidStyleValue(getStyle('itemRollOverColor')))
							color = getStyle('itemRollOverColor');
						else
							color = ColorUtil.adjustBrightness2(GraphicsUtilities.colorFromFill(fill),-20);
						fill = new SolidColor(color);		
						adjustedRadius = getStyle('adjustedRadius');
						if (!adjustedRadius)
							adjustedRadius = 0;
						break;
					}
					
				case ChartItem.DISABLED:
					
					if( appointment && appointment.isPatientAppointment() )
					{
						if (styleManager.isValidStyleValue(getStyle('itemDisabledColor')))
							color = getStyle('itemDisabledColor');
						else
							color = ColorUtil.adjustBrightness2(GraphicsUtilities.colorFromFill(fill),20);
						fill = new SolidColor(GraphicsUtilities.colorFromFill(color));
					}
					
					break;
				
				case ChartItem.FOCUSEDSELECTED:
				case ChartItem.SELECTED:
					
					if( appointment && appointment.isPatientAppointment() )
					{
						if (styleManager.isValidStyleValue(getStyle('itemSelectionColor')))
							color = getStyle('itemSelectionColor');
						else
							color = ColorUtil.adjustBrightness2(GraphicsUtilities.colorFromFill(fill),-30);
						fill = new SolidColor(color);				
						adjustedRadius = getStyle('adjustedRadius');
						if (!adjustedRadius)
							adjustedRadius = 0;
						break;
					}
			}
			
			var stroke:IStroke = getStyle("stroke");
			
			var w:Number = stroke ? stroke.weight / 2 : 0;
			
			var rc:Rectangle = new Rectangle(w - adjustedRadius, w - adjustedRadius, width - 2 * w + adjustedRadius * 2, height - 2 * w + adjustedRadius * 2);
			
			var g:Graphics = graphics;
			g.clear();
			
			// bg
			g.moveTo(rc.left,rc.top);
			
			if (fill)
				fill.begin(g,rc,null);
			
			g.lineTo(rc.right,rc.top);
			g.lineTo(rc.right,rc.bottom);
			g.lineTo(rc.left,rc.bottom);
			g.lineTo(rc.left,rc.top);
			
			if (fill)
				fill.end(g);
			
			//	stripes
			if( appointment
				&& !appointment.isPatientAppointment() )
			{
				var stripWidth:int=10;
				var xFrom:int = rc.left;
				var yFrom:int = stripWidth;
				var xTo:int = stripWidth;
				var yTo:int = rc.top;
				
				var xReached:Boolean = false;
				var yReached:Boolean = false;
				
				g.lineStyle(2,0xA0373A,1,false,ScaleMode.NONE,CapsStyle.SQUARE);
				
				while(yFrom < rc.bottom && xFrom < rc.right)
				{
					g.moveTo(xFrom,yFrom);
					g.lineTo(xTo,yTo);
					
					if( yFrom + stripWidth <= rc.height )
					{
						yFrom += stripWidth;
					}
					else
					{
						if( !yReached ) 
						{
							xFrom = yFrom + stripWidth - rc.height;
							yFrom = rc.height;
							
							yReached = true;
						}
						else
						{
							xFrom += stripWidth;
						}
					}
					
					if( xTo + stripWidth <= rc.width )
					{
						xTo += stripWidth;
					}
					else
					{
						if( !xReached ) 
						{
							yTo = xTo + stripWidth - rc.width;
							xTo = rc.width;
							
							xReached = true;
						}
						else
						{
							yTo += stripWidth;
						}
					}
				}
			}
			
			//	border
			g.moveTo(rc.left,rc.top);
			
			if (stroke)
				stroke.apply(g,null,null);
			
			g.lineTo(rc.right,rc.top);
			g.lineTo(rc.right,rc.bottom);
			g.lineTo(rc.left,rc.bottom);
			g.lineTo(rc.left,rc.top);
		}
	}
}