package gov.va.med.scheduling.util
{
	public class DateUtil
	{
		public static const SECOND:Number = 1000;
		public static const MINUTE:Number = SECOND * 60;
		public static const HOUR:Number = MINUTE * 60;
		public static const DAY:Number = HOUR * 24;
		public static const WEEK:Number = DAY * 7;
		public static const MONTH:Number = DAY * 30.4368;
		public static const YEAR:Number = MONTH * 12;
		
		public static  function modernizeDate( value:String ):String
		{
			var dateTimeParts:Array = value.split(' ');
			var date:String = dateTimeParts[0];
			var time:String = dateTimeParts.length > 1 ? ' ' + dateTimeParts[1] : '';
			
			var dateParts:Array = date.split('/');
			
			var today:Date = new Date();
			
			var now:Date = new Date( today.fullYear, today.month, today.date );
			
			var x:String = dateParts[0].substr(1);
			
			if( dateParts[0] == "*" ) 
				dateParts[0] = now.month;
			else if( new RegExp( /-|\+/ ).exec( dateParts[0] ) == null )
				now.month = parseInt( dateParts[0] );
			else 
				now.time += parseInt( dateParts[0].charAt(0) == "+" ? dateParts[0].substr(1) : dateParts[0] ) * MONTH;
			
			if( dateParts[1] == "*" ) 
				dateParts[1] = now.date;
			else if( new RegExp( />/ ).exec( dateParts[1] ) != null )
			{
				now.date += 1;
				
				while( now.day != parseInt( dateParts[1].substr(1) ) )
				{
					now.date += 1;
				}
			}
			else if( new RegExp( /-|\+/ ).exec( dateParts[1] ) == null )
				now.date = parseInt( dateParts[1] );
			else 
				now.time += parseInt( dateParts[1].charAt(0) == "+" ? dateParts[1].substr(1) : dateParts[1] ) * DAY;
			
			if( dateParts[2] == "*" ) 
				dateParts[2] = now.fullYear;
			else if( new RegExp( /-|\+/ ).exec( dateParts[2] ) == null )
				now.fullYear = parseInt( dateParts[2] );
			else 
				now.time += parseInt( dateParts[2].charAt(0) == "+" ? dateParts[2].substr(1) : dateParts[2] ) * YEAR;
			
			return (now.month+1) + '/' + now.date + '/' + now.fullYear + time;
		}
		
		public static function dateCompare( date1:Date, date2:Date ):Boolean
		{
			return date1.fullYear == date2.fullYear && date1.month == date2.month && date1.date == date2.date;
		}
	}
}