package gov.va.med.scheduling.model
{
	import gov.va.med.scheduling.enum.AppointmentStatus;
	import gov.va.med.scheduling.enum.AppointmentType;
	import gov.va.med.scheduling.util.DateUtil;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	public class PatientAppointment extends TimeSlot
	{
		public var classification:String;
		public var patient:UserModel;
		public var provider:*;
		public var status:String;
		
		public var type:String = AppointmentType.MEDICAL;
		
		public function PatientAppointment()
		{
			_scheduled = true;
		}
		
		public function get date():Date{ return from; }
		
		override public function set from(value:Date):void
		{
			super.from = value;
			
			if( from )
			{
				status = from.time < new Date().time ? AppointmentStatus.COMPLETED : AppointmentStatus.SCHEDULED;
			}
		}
		
		public static function fromObj( data:Object ):PatientAppointment
		{
			var val:PatientAppointment = new PatientAppointment();
			
			for (var prop:String in data)
			{
				if( val.hasOwnProperty( prop ) )
				{
					try{ val[prop] = data[prop]; }
					catch(e:Error){}
				}
			}
			
			if( data.hasOwnProperty('from') ) val.from = new Date( Date.parse( DateUtil.modernizeDate( data.from ) ) );
			if( data.hasOwnProperty('to') ) 
			{
				val.to = new Date( Date.parse( DateUtil.modernizeDate( data.to ) ) );
			}
			else if( val.from )
			{
				var to:Date = new Date();
				to.time = val.from.time + (1000 * 60 * 30);
				val.to = to;
			}
			
			//val.patient =  AppProperties.getInstance().controller.getUserById( data.patient_id, UserModel.TYPE_PATIENT );
			//val.provider = AppProperties.getInstance().controller.getUserById( data.provider_id, UserModel.TYPE_PROVIDER ) as ProviderModel;
			
			return val;
		}
	}
}