package gov.va.med.scheduling.event
{
	import flash.events.Event;
	
	import mx.rpc.AsyncResponder;
	
	import gov.va.med.scheduling.dto.AppointmentCategory;
	import gov.va.med.scheduling.dto.AppointmentReason;
	import gov.va.med.scheduling.dto.Clinic;
	import gov.va.med.scheduling.dto.Facility;
	import gov.va.med.scheduling.dto.Patient;
	import gov.va.med.scheduling.dto.Provider;
	
	public class ClinicEvent extends Event
	{
		public static const GET_APPOINTMENTS:String = "ClinicEvent.GET_APPOINTMENTS";
		public static const GET_APPOINTMENTS_BY_CLINIC:String = "ClinicEvent.GET_APPOINTMENTS_BY_CLINIC";
		public static const GET_CLINICS:String = "ClinicEvent.GET_CLINICS";
		public static const GET_CLINICS_TELEHEALTH:String = "ClinicEvent.GET_CLINICS_TELEHEALTH";
		public static const GET_FACILITIES:String = "ClinicEvent.GET_FACILITIES";
		public static const GET_VISIT_TYPES:String = "ClinicEvent.GET_VISIT_TYPES";
		
		public static const VIEW_CLINIC:String = "ClinicEvent.VIEW_CLINIC";
		
		public var category:AppointmentCategory;
		public var clinic:Clinic;
		public var facility:Facility;
		public var patient:Patient;
		public var provider:Provider;
		public var reason:AppointmentReason;
		
		public var responder:AsyncResponder;
		
		public function ClinicEvent( type:String )
		{
			super(type, true, true);
		}
		
		override public function clone():Event
		{
			var event:ClinicEvent = new ClinicEvent(type);
			return event;
		}
	}
}