package gov.va.med.scheduling.event
{
	import flash.events.Event;
	
	import mx.rpc.AsyncResponder;
	
	import gov.va.med.scheduling.dto.AppointmentCategory;
	import gov.va.med.scheduling.dto.Clinic;
	import gov.va.med.scheduling.dto.Facility;
	import gov.va.med.scheduling.dto.Patient;
	import gov.va.med.scheduling.dto.Provider;

	public class AppointmentEvent extends Event
	{
		public static const REQUEST_APPOINTMENT:String = "AppointmentEvent.REQUEST_APPOINTMENT";
		
		public static const GET_APPOINTMENT_CATEGORIES:String = "AppointmentEvent.GET_APPOINTMENT_CATEGORIES";
		public static const GET_VISIT_TYPES:String = "AppointmentEvent.GET_VISIT_TYPES";
		public static const GET_AVAILABLE_SLOTS:String = "AppointmentEvent.GET_AVAILABLE_SLOTS";
		
		public static const SET_SELECTED_SLOT:String = "AppointmentEvent.SET_SELECTED_SLOT";
		
		public static const VIEW_AVAILABILITY:String = "AppointmentEvent.VIEW_AVAILABILITY";
		
		public static const AVAILABILITY_LOADED:String = "AppointmentEvent.AVAILABILITY_LOADED";
		
		public static const CANCEL_APPOINTMENT:String = "AppointmentEvent.CANCEL_APPOINTMENT";
		public static const CONFIRM_APPOINTMENT:String = "AppointmentEvent.CONFIRM_APPOINTMENT";
		public static const CONFIRM_APPOINTMENT_SUCCESS:String = "AppointmentEvent.CONFIRM_APPOINTMENT_SUCCESS";
		
		public var data:*;
		
		public var category:AppointmentCategory;
		public var clinic:Clinic;
		public var facility:Facility;
		public var patient:Patient;
		public var provider:Provider;
		
		public var all:Boolean;
		public var context:String;
		public var responder:AsyncResponder;
		
		public var description:String;
		
		public function AppointmentEvent( type:String, data:* = null )
		{
			super(type, true, true);
			
			this.data = data;
		}
		
		override public function clone():Event
		{
			var event:AppointmentEvent = new AppointmentEvent(type, data);
			return event;
		}
	}
}