/**
 * Generated by Gas3 v2.3.2 (Granite Data Services).
 *
 * NOTE: this file is only generated if it does not exist. You may safely put
 * your custom code here.
 */

package gov.va.med.scheduling.dto 
{
	import flash.utils.IDataInput;
	import flash.utils.describeType;
	
	import mx.collections.ArrayCollection;
	
	import gov.va.med.scheduling.enum.AppointmentType;
	import gov.va.med.scheduling.util.DateUtil;
	import gov.va.med.scheduling.util.TimeZoneUtil;
	import gov.va.med.scheduling.view.components.calendar.interfaces.ICalendarItem;
	import gov.va.med.scheduling.view.components.calendar.interfaces.IScheduleOwner;

    [Bindable]
    [RemoteClass(alias="gov.va.med.scheduling.dto.Appointment")]
    public class Appointment extends AppointmentBase implements ICalendarItem 
	{
		/**
		 * ICalendarItem
		 */
		private var _from:Date;
		private var _to:Date;
		private var _selected:Boolean;
		
		protected var _scheduled:Boolean;
		protected var _owner:IScheduleOwner;
		
		public var categoryDirty:Boolean;
		public var clinicDirty:Boolean;
		public var facilityDirty:Boolean;
		public var patientDirty:Boolean;
		public var providerDirty:Boolean;
		public var visitTypeDirty:Boolean;
		
		public var actualClinic:Clinic;
		public var actualFacility:Facility;
		
		private var _spokeClinic:Clinic;
		private var _spokeFacility:Facility;
		
		public var type:String;
		public var startDateTimeClinicDate:Date;
		public var endDateTimeClinicDate:Date;
		
		public function Appointment()
		{
			super();
			
			_scheduled = true;
			
			type = AppointmentType.MEDICAL;
		}
		
		public function get owner():IScheduleOwner
		{
			return _owner;
		}
		
		public function set owner(value:IScheduleOwner):void
		{
			_owner = value;
		}
		
		public function get description():String
		{
			if( isHoliday() || isRecurring() ) return reasonText;
			
			var fields:Array = [visitType ? visitType.description : null, clinic ? clinic.name : null, provider ? provider.name : null];
			
			for(var i:int=0;i<fields.length;i++)
				if( fields[i] != null && fields[i] != "" ) 
					return fields[i];
			
			return 'Appointment'; 
		}
			
		public function set description(value:String):void {}
		
		
		public function get from():Date{ return _from; }
		public function set from(value:Date):void { _from = value; }
		
		public function get to():Date{ return _to; }
		public function set to(value:Date):void { _to = value; }
		
		public function get selected():Boolean { return _selected; }
		public function set selected(value:Boolean):void { _selected = value; }
		
		public function get isScheduled():Boolean { return _scheduled; };
		
		public function get date():Date { return this.from; }
		
		override public function set category(value:AppointmentCategory):void 
		{
			categoryDirty = category != value;
			
			super.category = value;
		}
		
		override public function set clinic(value:Clinic):void 
		{
			clinicDirty = clinic != value;
			
			super.clinic = value;
			
			if( clinic ) actualClinic = clinic;
		}
		
		override public function set facility(value:Facility):void 
		{
			facilityDirty = facility != value;
			
			super.facility = value;
			
			actualFacility = facility;
		}
		
		override public function set patient(value:Patient):void 
		{
			patientDirty = patient != value;
			
			super.patient = value;
		}
		
		override public function set provider(value:Provider):void 
		{
			providerDirty = provider != value;
			
			super.provider = value;
		}
		
		override public function set visitType(value:VisitType):void 
		{
			visitTypeDirty = visitType != value;
			
			super.visitType = value;
		}
		
		/**
		 * When idSpokeClinic is set to a null value, re-initialize actualClinic/actualFacility to clinic/facility
		 */
		override public function set idSpokeClinic(value:String):void
		{
			super.idSpokeClinic = value;
			
			if( !idSpokeClinic ) 
			{
				actualClinic = clinic;
				actualFacility = facility;
			}
		}
		
		/**
		 * When a spokeClinic is seleted, set actualClinic = spokeClinic
		 */
		public function set spokeClinic(value:Clinic):void 
		{
			_spokeClinic = value;
			
			if( spokeClinic ) actualClinic = spokeClinic;
		}
		
		public function get spokeClinic():Clinic{ return _spokeClinic; }
		
		/**
		 * When a spokeFacility is selected, set actualFacility = spokeFacility
		 */
		public function set spokeFacility(value:Facility):void 
		{
			_spokeFacility = value;
			
			if( spokeFacility ) actualFacility = spokeFacility;
		}
		
		public function get spokeFacility():Facility{ return _spokeFacility; }
		
		override public function readExternal(input:IDataInput):void 
		{
			super.readExternal(input);
			
			_from = startDateTime;
			_to = endDateTime;
			_owner = provider;
			
			if( startDateTimeClinic 
				&& !isHoliday() )
			{
				var timeZoneAbbreviation:String = startDateTimeClinic.substr( startDateTimeClinic.lastIndexOf(" ")+1 );
				var timeZoneOffset:Number = TimeZoneUtil.getTimeZoneOffsetForGMT( timeZoneAbbreviation );
				
				var startDate:Date = new Date( Date.parse(startDateTimeClinic) );
				var endDate:Date = new Date( Date.parse(endDateTimeClinic) );
				
				_from = new Date( startDate.fullYearUTC, startDate.monthUTC, startDate.dateUTC, startDate.hoursUTC, startDate.minutesUTC, startDate.millisecondsUTC );
				_from.time += (timeZoneOffset * DateUtil.HOUR);
				
				_to = new Date( endDate.fullYearUTC, endDate.monthUTC, endDate.dateUTC, endDate.hoursUTC, endDate.minutesUTC, endDate.millisecondsUTC );
				_to.time += (timeZoneOffset * DateUtil.HOUR);
			}
		}
		
		public function isPatientAppointment():Boolean
		{
			return !(isHoliday() || isRecurring());
		}
		
		public function isHoliday():Boolean
		{
			return category != null && (category.id == AppointmentCategory.CATEGORY_HOLIDAY || category.id == AppointmentCategory.CATEGORY_UNAVAILABLE);
		}
		
		public function isRecurring():Boolean
		{
			var id:String = reasonText.toLowerCase();
			
			return id == "saturday" || id == "sunday" || id == "morning" || id == "evening" || id == "lunchbreak";
		}
		
		public function clone():Appointment
		{
			var val:Appointment = new Appointment();
			
			var definition:XML = describeType(this);
			
			for each(var prop:XML in definition..accessor)
			{
				if( prop.@access == "readonly" ) continue;
				
				if( val.hasOwnProperty( prop.@name ) )
				{
					try
					{
						if( this[prop.@name].hasOwnProperty('clone') 
							&& this[prop.@name].clone is Function )
							val[prop.@name] = this[prop.@name].clone();
						if( this[prop.@name] is ArrayCollection )
							val[prop.@name] = new ArrayCollection( (this[prop.@name].source as Array).slice() );
						else
							val[prop.@name] = this[prop.@name]; 
					}
					catch(e:Error){}
				}
			}
			
			return val;
		}
    }
}