package gov.va.med.scheduling.controller
{
	import flash.events.EventDispatcher;
	
	import mx.collections.ArrayCollection;
	import mx.managers.CursorManager;
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	import gov.va.med.scheduling.dto.AppointmentCategory;
	import gov.va.med.scheduling.dto.Clinic;
	import gov.va.med.scheduling.dto.Response;
	import gov.va.med.scheduling.dto.Role;
	import gov.va.med.scheduling.dto.Scheduler;
	import gov.va.med.scheduling.dto.User;
	import gov.va.med.scheduling.event.AppointmentEvent;
	import gov.va.med.scheduling.event.ClinicEvent;
	import gov.va.med.scheduling.event.PatientEvent;
	import gov.va.med.scheduling.event.ProviderEvent;
	import gov.va.med.scheduling.event.SchedulerEvent;
	import gov.va.med.scheduling.event.login.LoginResultEvent;
	
	[Name("SchedulerController")]
	[ManagedEvent(name="SchedulerEvent.GET_DETAILS")]
	[ManagedEvent(name="ClinicEvent.GET_FACILITIES")]
	[ManagedEvent(name="PatientEvent.GET_PATIENTS")]
	[ManagedEvent(name="ProviderEvent.GET_PROVIDERS")]
	[ManagedEvent(name="ProviderEvent.GET_ALL_PROVIDERS")]
	[ManagedEvent(name="AppointmentEvent.GET_APPOINTMENT_CATEGORIES")]
	public class SchedulerController extends EventDispatcher
	{
		private var schedulerService:RemoteObject;
		
		[Bindable] [Out] public var scheduler:Scheduler;
		[Bindable] [In] public var user:User;
		[Bindable] [Out] public var categories:ArrayCollection;
		[Bindable] [Out] public var spokeCategories:ArrayCollection;
		[Bindable] [Out] public var patients:ArrayCollection;
		[Bindable] [Out] public var allProviders:ArrayCollection;
		
		public function SchedulerController()
		{
			super();
			
			schedulerService  = new RemoteObject("profileService");
		}
		
		public function init():void
		{
		}
		
		[Observer("LoginResultEvent.LOGIN_SUCCESS")]
		public function onLoginSuccess(event:LoginResultEvent):void
		{
			if( user.role.idRole == Role.ID_SCHEDULER )
			{
				CursorManager.setBusyCursor();
				
				var evt:SchedulerEvent = new SchedulerEvent( SchedulerEvent.GET_DETAILS );
				evt.user = user;
				evt.responder = new AsyncResponder( onGetSchedulerDetailsSuccess, onDataLoadFail );
				dispatchEvent( evt );
				
				var aEvt:AppointmentEvent = new AppointmentEvent( AppointmentEvent.GET_APPOINTMENT_CATEGORIES );
				aEvt.all = true;
				aEvt.responder = new AsyncResponder( onGetAppointmentTypeCategories, onDataLoadFail );
				dispatchEvent( aEvt );
				
				var aaEvt:AppointmentEvent = new AppointmentEvent( AppointmentEvent.GET_APPOINTMENT_CATEGORIES );
				aaEvt.responder = new AsyncResponder( onGetAppointmentTypeCategoriesSpoke, onDataLoadFail );
				dispatchEvent( aaEvt );
			}
		}
		
		private function onGetSchedulerDetailsSuccess( result:ResultEvent, token:Object = null ) : void 
		{
			var response:Response = result.result as Response;
			
			if( response.responseList 
				&& response.responseList.length )
			{
				scheduler = response.responseList.getItemAt(0) as Scheduler;
				
				var evt:ClinicEvent = new ClinicEvent( ClinicEvent.GET_FACILITIES );
				evt.responder = new AsyncResponder( onGetSchedulerFacilitiesSuccess, onDataLoadFail );
				dispatchEvent( evt );
				
				var pEvt:PatientEvent = new PatientEvent( PatientEvent.GET_PATIENTS );
				pEvt.facility = scheduler.defaultFacility;
				pEvt.responder = new AsyncResponder( onPatientsLoaded, onDataLoadFail );
				dispatchEvent( pEvt );
				
				var praEvt:ProviderEvent = new ProviderEvent( ProviderEvent.GET_ALL_PROVIDERS );
				praEvt.responder = new AsyncResponder( onAllProvidersLoaded, onDataLoadFail );
				dispatchEvent( praEvt );
			}
		}
		
		private function onGetAppointmentTypeCategories( event:ResultEvent, token:Object = null ):void
		{
			var response:Response = event.result as Response;
			
			if( response.responseList 
				&& response.responseList.length 
				&& response.responseList.getItemAt(0) is ArrayCollection )
			{
				categories = response.responseList.getItemAt(0) as ArrayCollection;
			}
		}
		
		private function onGetAppointmentTypeCategoriesSpoke( event:ResultEvent, token:Object = null ):void
		{
			var response:Response = event.result as Response;
			
			if( response.responseList 
				&& response.responseList.length 
				&& response.responseList.getItemAt(0) is ArrayCollection )
			{
				spokeCategories = response.responseList.getItemAt(0) as ArrayCollection;
				
				for each(var category:AppointmentCategory in spokeCategories)
				{
					if( category.id == AppointmentCategory.CATEGORY_REGULAR )
					{
						category.description = "Office Visit";
					}
				}
			}
			
			CursorManager.removeBusyCursor();
		}
		
		private function onGetSchedulerFacilitiesSuccess( result:ResultEvent, token:Object = null ) : void 
		{
			var response:Response = result.result as Response;
			
			if( response.responseList 
				&& response.responseList.length
				&& response.responseList.getItemAt(0) is ArrayCollection )
			{
				scheduler.facilities = response.responseList.getItemAt(0) as ArrayCollection;
			}
		}
		
		private function onPatientsLoaded( event:ResultEvent, token:Object = null ):void
		{
			var response:Response = event.result as Response;
			
			if( response.responseList 
				&& response.responseList.length 
				&& response.responseList.getItemAt(0) is ArrayCollection )
			{
				patients = response.responseList.getItemAt(0) as ArrayCollection;
			}
		}
		
		private function onAllProvidersLoaded( event:ResultEvent, token:Object = null ):void
		{
			var response:Response = event.result as Response;
			
			if( response.responseList 
				&& response.responseList.length 
				&& response.responseList.getItemAt(0) is ArrayCollection )
			{
				allProviders = response.responseList.getItemAt(0) as ArrayCollection;
			}
		}
		
		private function onDataLoadFail( event:FaultEvent, token:Object = null ):void{ CursorManager.removeBusyCursor(); }
		
		/**
		 * ProfileService.getSchedulerDetails
		 */
		[Observer("SchedulerEvent.GET_DETAILS")]
		public function onGetSchedulerDetails( event:SchedulerEvent ):void
		{
			getSchedulerDetails( event.user, event.responder );
		}
		
		private function getSchedulerDetails( user:User, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = schedulerService.getSchedulerProfile( user );
			
			if( responder ) token.addResponder( responder );
		}
	}
}