package gov.va.med.scheduling.controller
{
	import flash.events.EventDispatcher;
	
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	import gov.va.med.scheduling.dto.Clinic;
	import gov.va.med.scheduling.dto.Facility;
	import gov.va.med.scheduling.event.ProviderEvent;
	
	[Name("ProviderController")]
	public class ProviderController extends EventDispatcher
	{
		private var providerService:RemoteObject;
		
		public function ProviderController()
		{
			super();
			
			providerService  = new RemoteObject("providerService");
		}
		
		public function init():void
		{
		}
		
		/**
		 */
		[Observer("ProviderEvent.GET_PROVIDERS")]
		public function onGetProviders( event:ProviderEvent ):void
		{
			getProviders( event.facility, event.clinic, event.responder );
		}
		
		private function getProviders( facility:Facility, clinic:Clinic, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = providerService.getProviders( facility, clinic );
			
			if( responder ) token.addResponder( responder );
		}
		
		[Observer("ProviderEvent.GET_ALL_PROVIDERS")]
		public function onGetAllProviders( event:ProviderEvent ):void
		{
			getAllProviders( event.responder );
		}
		
		private function getAllProviders( responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = providerService.getAllProviders( );
			
			if( responder ) token.addResponder( responder );
		}
	}
}