package gov.va.med.scheduling.controller
{
	import flash.events.EventDispatcher;
	
	import mx.collections.ArrayCollection;
	import mx.core.FlexGlobals;
	import mx.managers.PopUpManager;
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	import spark.components.Application;
	import spark.components.TitleWindow;
	
	import gov.va.med.scheduling.dto.Appointment;
	import gov.va.med.scheduling.dto.Facility;
	import gov.va.med.scheduling.dto.Patient;
	import gov.va.med.scheduling.dto.Response;
	import gov.va.med.scheduling.dto.Role;
	import gov.va.med.scheduling.dto.User;
	import gov.va.med.scheduling.event.AppointmentEvent;
	import gov.va.med.scheduling.event.PatientEvent;
	import gov.va.med.scheduling.event.login.LoginResultEvent;
	import gov.va.med.scheduling.view.UserProfileForm;
	import gov.va.med.scheduling.view.popups.MakeAppointmentPopup;
	import gov.va.med.scheduling.view.popups.MakeAppointmentPopupScheduler;
	
	[Name("PatientController")]
	[ManagedEvent(name="PatientEvent.GET_DETAILS")]
	[ManagedEvent(name="PatientEvent.GET_FACILITIES")]
	public class PatientController extends EventDispatcher
	{
		private var patientService:RemoteObject;
		
		[Bindable] [Out] public var patient:Patient;
		[Bindable] [In] public var user:User;
		
		public function PatientController()
		{
			super();
			
			patientService  = new RemoteObject("patientService");
		}
		
		/**
		 * Listen for login success and begin initialization sequence by calling 
		 * 1) patientService.getPatientDetails followed by 2) patientService.getFacilities
		 */
		[Observer("LoginResultEvent.LOGIN_SUCCESS")]
		public function onLoginSuccess(event:LoginResultEvent):void
		{
			if( user.role.idRole == Role.ID_PATIENT )
			{
				var evt:PatientEvent = new PatientEvent( PatientEvent.GET_DETAILS );
				evt.user = user;
				evt.responder = new AsyncResponder( onGetPatientDetailsSuccess, onGetPatientDetailsFail );
				dispatchEvent( evt );
			}
		}
		
		private function onGetPatientDetailsSuccess( result:ResultEvent, token:Object = null ) : void 
		{
			var response:Response = result.result as Response;
			
			if( response.responseList 
				&& response.responseList.length )
			{
				patient = response.responseList.getItemAt(0) as Patient;
				
				var evt:PatientEvent = new PatientEvent( PatientEvent.GET_FACILITIES );
				evt.patient = patient;
				evt.responder = new AsyncResponder( onGetPatientFacilitiesSuccess, onGetPatientDetailsFail );
				dispatchEvent( evt );
			}
		}
		
		private function  onGetPatientDetailsFail( result:FaultEvent, token:Object = null ):void {}
		
		private function onGetPatientFacilitiesSuccess( result:ResultEvent, token:Object = null ) : void 
		{
			var response:Response = result.result as Response;
			
			if( response.responseList 
				&& response.responseList.length
				&& response.responseList.getItemAt(0) is ArrayCollection )
			{
				patient.facilities = response.responseList.getItemAt(0) as ArrayCollection;
			}
		}
		
		private function  onGetPatientFacilitiesFail( result:FaultEvent, token:Object = null ):void {}
		
		/**
		 * PatientService.getPatientDetails
		 */
		[Observer("PatientEvent.GET_DETAILS")]
		public function onGetPatientDetails( event:PatientEvent ):void
		{
			if( event.patient )
				getPatientDetailsByPatient( event.patient, event.responder );
			else
				getPatientDetails( event.user, event.responder );
		}
		
		private function getPatientDetails( user:User, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = patientService.getPatientDetails( user );
			
			if( responder ) token.addResponder( responder );
		}
		
		private function getPatientDetailsByPatient( patient:Patient, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = patientService.getPatientDetails( patient );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 * PatientService.getPatientFacilities
		 */
		[Observer("PatientEvent.GET_FACILITIES")]
		public function onGetPatientFacilities( event:PatientEvent ):void
		{
			getPatientFacilities( event.user, event.patient, event.responder );
		}
		
		private function getPatientFacilities( user:User, patient:Patient, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = patientService.getFacilities( user, patient );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 * 
		 */
		[Observer("PatientEvent.GET_APPOINTMENTS")]
		public function onGetExistingAppointments( event:PatientEvent ):void
		{
			getAppointmentsByPatient( event.patient, event.responder );
		}
		
		private function getAppointmentsByPatient( patient:Patient, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = patientService.getAppointmentsByPatient( user, patient );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 * 
		 */
		[Observer("PatientEvent.GET_PATIENTS")]
		public function onGetPatients( event:PatientEvent ):void
		{
			getPatients( event.facility, event.responder );
		}
		
		private function getPatients( facility:Facility, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = patientService.getPatients( facility );
			
			if( responder ) token.addResponder( responder );
		}
		
		[Observer("PatientEvent.VIEW_PATIENT_PROFILE")]
		public function onViewPatientProfile( event:PatientEvent ):void
		{
			var popup:TitleWindow = PopUpManager.createPopUp( FlexGlobals.topLevelApplication as Application, UserProfileForm, true ) as TitleWindow;
			
			UserProfileForm(popup).patient = event.patient;
			
			PopUpManager.centerPopUp( popup );
		}
	}
}