package gov.va.med.scheduling.controller
{
	import flash.events.EventDispatcher;
	
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	import gov.va.med.scheduling.dto.User;
	import gov.va.med.scheduling.event.login.LoginEvent;
	import gov.va.med.scheduling.event.login.LoginResultEvent;
	
	[Name("Controller")]
	[ManagedEvent(name="LoginResultEvent.LOGIN_SUCCESS")]
	[ManagedEvent(name="LoginResultEvent.LOGIN_ERROR")]
	public class Controller extends EventDispatcher
	{
		private var securityService:RemoteObject;
		
		[Bindable] [Out] public var user:User;
		
		public function Controller()
		{
			securityService = new RemoteObject("securityService");
		}
		
		/**
		 * SecurityService.login
		 */
		[Observer("LoginEvent.LOGIN")]
		public function onLogin( event:LoginEvent ):void
		{
			authenticateUser( event.username, event.password, new AsyncResponder(onLoginSuccess,onLoginFail) );
		}
		
		private function authenticateUser( username:String, password:String, responder:AsyncResponder = null ):void
		{
			var token:AsyncToken = securityService.authenticateUser( username, password );
			
			if( responder ) token.addResponder( responder );
		}
		
		private function onLoginSuccess( result:ResultEvent, token:Object = null  ) :void
		{
			if( result.result )
			{
				user = result.result as User;
				
				dispatchEvent( new LoginResultEvent( LoginResultEvent.LOGIN_SUCCESS ) );
			}
			else
			{
				dispatchEvent( new LoginResultEvent( LoginResultEvent.LOGIN_ERROR ) );
			}
		}
		
		private function onLoginFail( result:FaultEvent, token:Object = null ):void {}
	}
}