package gov.va.med.scheduling.controller
{
	import flash.events.EventDispatcher;
	
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	import gov.va.med.scheduling.dto.Clinic;
	import gov.va.med.scheduling.dto.Facility;
	import gov.va.med.scheduling.dto.Provider;
	import gov.va.med.scheduling.dto.User;
	import gov.va.med.scheduling.event.ClinicEvent;
	
	[Name("ClinicController")]
	public class ClinicController extends EventDispatcher
	{
		private var clinicService:RemoteObject;
		private var patientService:RemoteObject;
		
		[Bindable] [In] public var user:User;
		
		public function ClinicController()
		{
			super();
			
			clinicService  = new RemoteObject("clinicService");
		}
		
		public function init():void
		{
		}
		
		/**
		 */
		[Observer("ClinicEvent.GET_VISIT_TYPES")]
		public function onGetVisitTypes( event:ClinicEvent ):void
		{
			getVisitTypes( event.facility, event.clinic, event.provider, event.responder );
		}
		
		private function getVisitTypes( facility:Facility, clinic:Clinic, provider:Provider = null, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = clinicService.getVisitTypes( facility, clinic );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 */
		[Observer("ClinicEvent.GET_CLINICS")]
		public function onGetClinics( event:ClinicEvent ):void
		{
			getClinics( user, event.facility, event.responder );
		}
		
		private function getClinics( user:User, facility:Facility, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = clinicService.getClinics( user, facility );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 */
		[Observer("ClinicEvent.GET_CLINICS_TELEHEALTH")]
		public function onGetClinicsTelehealth( event:ClinicEvent ):void
		{
			getClinicsTelehealth( user, event.facility, event.responder );
		}
		
		private function getClinicsTelehealth( user:User, facility:Facility, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = clinicService.getSpokeClinics( user, facility );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 */
		[Observer("ClinicEvent.GET_APPOINTMENTS")]
		public function onGetAppointments( event:ClinicEvent ):void
		{
			getAppointments( user, event.clinic, event.responder );
		}
		
		private function getAppointments( user:User, clinic:Clinic, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = clinicService.getAppointments( user, clinic );
			
			if( responder ) token.addResponder( responder );
		}
		
		
		[Observer("ClinicEvent.GET_APPOINTMENTS_BY_CLINIC")]
		public function onGetExistingAppointments( event:ClinicEvent ):void
		{
			getAppointmentsByClinic( event.facility, event.clinic, event.responder );
		}
		
		private function getAppointmentsByClinic( facility:Facility, clinic:Clinic, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = clinicService.getAppointmentsByClinic( user, facility, clinic );
			
			if( responder ) token.addResponder( responder );
		}
		
		[Observer("ClinicEvent.GET_FACILITIES")]
		public function onGetFacilities( event:ClinicEvent ):void
		{
			getFacilities( user, event.responder );
		}
		
		private function getFacilities( user:User, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = clinicService.getFacilities( user );
			
			if( responder ) token.addResponder( responder );
		}
	}
}