package gov.va.med.scheduling.controller
{
	import flash.events.EventDispatcher;
	
	import mx.controls.Alert;
	import mx.core.FlexGlobals;
	import mx.managers.CursorManager;
	import mx.managers.PopUpManager;
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	import spark.components.Application;
	import spark.components.TitleWindow;
	
	import gov.va.med.scheduling.dto.Appointment;
	import gov.va.med.scheduling.dto.Clinic;
	import gov.va.med.scheduling.dto.Response;
	import gov.va.med.scheduling.dto.Role;
	import gov.va.med.scheduling.dto.User;
	import gov.va.med.scheduling.event.AppointmentEvent;
	import gov.va.med.scheduling.view.popups.MakeAppointmentPopup;
	import gov.va.med.scheduling.view.popups.MakeAppointmentPopupScheduler;
	
	[Name("AppointmentsController")]
	[ManagedEvent(name="AppointmentEvent.CONFIRM_APPOINTMENT_SUCCESS")]
	public class AppointmentsController extends EventDispatcher
	{
		private var application:Application;
		
		private var appointmentService:RemoteObject;
		
		private var popup:TitleWindow;
		
		[Bindable] [In] public var user:User;
		
		[Bindable] [Out] public var selections:Appointment;
		[Bindable] [Out] public var tempSelections:Appointment;
		[Bindable] [Out] public var selectedSlot:Appointment;
		
		public function AppointmentsController()
		{
			super();
			
			appointmentService  = new RemoteObject("appointmentService");
		}
		
		public function init():void
		{
		}
		
		/**
		 */
		[Observer("AppointmentEvent.GET_APPOINTMENT_CATEGORIES")]
		public function onGetAppointmentCategories( event:AppointmentEvent ):void
		{
			getAppointmentCategories( event.all, event.responder );
		}
		
		private function getAppointmentCategories(getAll:Boolean = false, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = appointmentService.getAppointmentCategories( getAll );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 */
		[Observer("AppointmentEvent.GET_AVAILABLE_SLOTS")]
		public function onGetAvailableSlots( event:AppointmentEvent ):void
		{
			getAvailableSlots( event.data as Appointment, event.responder );
		}
		
		private function getAvailableSlots( selections:Appointment, responder:AsyncResponder = null ):void 
		{
			var token:AsyncToken = appointmentService.getAvailableSlots( user, selections );
			
			if( responder ) token.addResponder( responder );
		}
		
		/**
		 */
		[Observer("AppointmentEvent.CONFIRM_APPOINTMENT")]
		public function onConfirmAppointment( event:AppointmentEvent ):void
		{
			confirmAppointment( event.data as Appointment, event.responder );
		}
		
		private function confirmAppointment( appointment:Appointment, responder:AsyncResponder = null ):void 
		{
			if( popup ) popup.enabled = false;
			
			CursorManager.setBusyCursor();
			
			var token:AsyncToken = appointmentService.makeAppointment( appointment );
			
			token.addResponder( new AsyncResponder( onConfirmAppointmentSuccess, onConfirmAppointmentFail ) );
			
			if( responder ) token.addResponder( responder );
		}
		
		private function onConfirmAppointmentSuccess(event:ResultEvent, token:Object = null):void
		{
			var response:Response = event.result as Response;
			
			if( response.responseList 
				&& response.responseList.length 
				&& response.responseList.getItemAt(0) is Appointment )
			{
				if( popup ) PopUpManager.removePopUp( popup );
				
				popup = null;
				
				var appointment:Appointment = response.responseList.getItemAt(0) as Appointment;
				
				if( appointment.idSpokeClinic 
					&& appointment.idSpokeClinic.toLowerCase() == Clinic.HOME 
					&& user.role.idRole == Role.ID_SCHEDULER )
				{
					Alert.show( "This version of the prototype does not display telehealth appointments scheduled for patient home on clinic calendars.\n\nPlease open the calendar for " + (appointment.patient?appointment.patient.name:"[patient]") + " to view the scheduled appointment." );
				}
				
				var evt:AppointmentEvent = new AppointmentEvent( AppointmentEvent.CONFIRM_APPOINTMENT_SUCCESS );
				evt.data = appointment;
				dispatchEvent( evt );
			}
			
			CursorManager.removeBusyCursor();
		}
		
		private function onConfirmAppointmentFail(event:FaultEvent, token:Object = null):void{ if( popup ) popup.enabled = false; CursorManager.removeBusyCursor(); }
		
		/**
		 */
		[Observer("AppointmentEvent.REQUEST_APPOINTMENT")]
		public function onRequestAppointment( event:AppointmentEvent ):void
		{
			selections = new Appointment();
			tempSelections = new Appointment();
			selectedSlot = null;
			
			popup = PopUpManager.createPopUp( FlexGlobals.topLevelApplication as Application, user.role.idRole == Role.ID_SCHEDULER ? MakeAppointmentPopupScheduler : MakeAppointmentPopup, true ) as TitleWindow;
			
			if( popup is MakeAppointmentPopupScheduler )
			{
				MakeAppointmentPopupScheduler(popup).context = event.context;
				
				MakeAppointmentPopupScheduler(popup).patient = event.patient;
				MakeAppointmentPopupScheduler(popup).clinic = event.clinic;
				MakeAppointmentPopupScheduler(popup).facility = event.facility;
			}
			
			PopUpManager.centerPopUp( popup );
		}
		
		[Observer("AppointmentEvent.SET_SELECTED_SLOT")]
		public function onSetSelectedSlot( event:AppointmentEvent ):void
		{
			selectedSlot = event.data as Appointment;
		}
	}
}