﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using Shared.Model.UserRoles;

namespace Shared.Model
{
    public class User 
    {
        public virtual int Id { get; set; }
        public virtual Person Person { get; set; }
        public virtual string Username { get; set; }
        public virtual string Password { get; set; }
        public virtual string Salt { get; set; }

        public virtual IList<UserRole> Roles { get; set; }

        public User()
        {
            Roles = new List<UserRole>();            
        }

        public void AddRole(UserRole userRole)
        {
            Roles.Add(userRole);
        }
    }
}
