﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shared.Model
{
    public class Section
    {
        public virtual int Id { get; set; }
        public virtual string Name { get; set; }
        public virtual Service Service { get; set; }
        public virtual string DSSPrimaryStopCode { get; set; }
        public virtual string DSSCreditStopCode { get; set; }
        public virtual string Abbreviation { get; set; }
        public virtual Facility Facility { get; set; }
        public virtual string Hours { get; set; }
        public virtual string Location { get; set; }
        public virtual bool Active { get; set; }
        public virtual IList<CommunicationTemplate> CommunicationTemplates { get; set; }
        public virtual IList<AppointmentType> AppointmentTypes { get; set; }

        public Section()
        {
            CommunicationTemplates = new List<CommunicationTemplate>();
            AppointmentTypes = new List<AppointmentType>();
        }

        public void AddAppointmentType(AppointmentType appType)
        {
//            appType.Section = this;
            AppointmentTypes.Add(appType);
        }

    }
}
