﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace Shared.Model
{
    public class Resource
    {
        public virtual int Id { get; set; }
        public virtual string Name { get; set; }
        public virtual int FullfillingResourceId { get; set; }
        public virtual ResourceType Type { get; set; }
        public virtual string ServiceType { get; set; } // not sure if this is needed, or just assumed from the Section level
        public virtual Section Section { get; set; }
        public virtual string CalendarID { get; set; }
        public virtual string VistaClinicIEN { get; set; } // if this is a provider resource
        public virtual bool AllowOverbooking { get; set; }
        public virtual IList<Hold> Holds { get; set; }
        public virtual IList<Block> Blocks { get; set; }
        public virtual IList<SchedulingPolicy> SchedulingPolicies { get; set; }

        public Resource()
        {
            Holds = new List<Hold>();
            Blocks = new List<Block>();
            SchedulingPolicies = new List<SchedulingPolicy>();
        }

        public void AddHold(Hold hold)
        {
//            hold.Resource = this;
            Holds.Add(hold);
        }

        public void AddBlock(Block block)
        {
//            block.Resource = this;
            Blocks.Add(block);
        }

        public void AddShedulingPolicy(SchedulingPolicy schedulingPolicy)
        {
//            schedulingPolicy.Resource = this;
            SchedulingPolicies.Add(schedulingPolicy);
        }
    }

    public enum ResourceType { Provider, Room, Equipment };
}
