﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Collections.ObjectModel;

namespace Shared.Model
{
    public class Provider
    {
        public virtual int Id { get; set; }
        public virtual Person Person { get; set; }
//        public virtual IList<ProviderSite> ProviderSites { get; set; }
        public virtual IDictionary<string, string> ProviderSites { get; set; }
        public virtual string NPI { get; set; }
        public virtual string CaldavResourceId { get; set; }

        public Provider()
        {
//            ProviderSites = new List<ProviderSite>();
            ProviderSites = new Dictionary<string, string>();
        }

        public virtual string GetDUZForVistASite(string site)
        {
            //var providerSites = ProviderSites.Where(ps => ps.VistaSiteId == site);
            //if (providerSites != null && providerSites.Count() > 0)
            //{
            //    return providerSites.First().DUZ;
            //}
            //return null;
            if(ProviderSites.ContainsKey(site))
                return ProviderSites[site];
            return null;
        }

        public virtual void AddProviderSite(string vistaSiteId, string duz)
        {
            //proSite.Provider = this;
            //this.ProviderSites.Add(proSite);
            ProviderSites[vistaSiteId] = duz;
        }
    }
}