﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Shared.Model
{
    public class Patient
    {
        public virtual int Id { get; set; }
        public virtual Person Person { get; set; }
//        public virtual IList<PatientSite> PatientSites { get; set; }
        public virtual IDictionary<string, string> PatientSites { get; set; }

        public virtual string CaldavResourceId { get; set; }
        public virtual string ICN { get; set; }

        public virtual IList<SpecialNeed> SpecialNeeds { get; set; }
        public virtual string SpecialNeedsOther { get; set; }
        public virtual IList<PatientPreference> Preferences { get; set; }
        public virtual string PreferencesOther { get; set; }

        public virtual bool HasInsurance { get; set; }
        public virtual string ActiveInsurance { get; set; }
        public virtual string EligibilityCode { get; set; }
        public virtual string CurrentMeansStatus { get; set; }
        public virtual bool NeedsMeansTest { get; set; }
        public virtual string MilitaryStatus { get; set; }
        public virtual string Occupation { get; set; }
        public virtual bool IsVeteran { get; set; }
        public virtual bool ServiceConnected { get; set; }
        public virtual int SCPercent { get; set; }
        public virtual string Religion { get; set; }
        public virtual string PatientType { get; set; }
        
//        patientFlags
        // preferredFacility
        // relationships


        public Patient()
        {
            PatientSites = new Dictionary<string, string>();
            SpecialNeeds = new List<SpecialNeed>();
            Preferences = new List<PatientPreference>();
        }

        public virtual string GetDFNForVistASite(string site)
        {
            //var patientSites = PatientSites.Where(ps => ps.VistaSiteId == site);
            //if (patientSites != null && patientSites.Count() > 0)
            //{
            //    return patientSites.First().DFN;
            //}
            //return null;
            if (PatientSites.ContainsKey(site))
                return PatientSites[site];
            return null;
        }

        public virtual void AddPatientSite(string VistaSiteId, string dfn)
        {
        //    patSite.Patient = this;
        //    this.PatientSites.Add(patSite);
            PatientSites[VistaSiteId] = dfn;
        }

        public virtual void AddSpecialNeed(SpecialNeedType type)
        {
            var specialNeed = new SpecialNeed() { /*Patient = this,*/ SpecialNeedType = type };
            this.SpecialNeeds.Add(specialNeed);
        }

        public virtual void AddPatientPreference(PatientPreferenceType type)
        {
            var pref = new PatientPreference() { /*Patient = this,*/ PatientPreferenceType = type };
            this.Preferences.Add(pref);
        }

    }
}