﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Shared.Model.Config.Calendar;

namespace Shared.Model.Config.MDWS
{
    public class MDWSConfiguration : ExcludeMapping
    {
        private Dictionary<string, DataSource> _dataSources;
        private Dictionary<string, MDWSConnection> _serviceAccounts;

        public string BaseMDWS_Url { get; set; }
        public Dictionary<string, DataSource> DataSources { get { return _dataSources; } }
        public Dictionary<string, MDWSConnection> ServiceAccounts { get { return _serviceAccounts; } }

        public string DB_ConnectionString { get; set; }

        public CalendarConfiguration Caldav_Source {get; set;}

        public MDWSConfiguration()
        {
            _dataSources = new Dictionary<string, DataSource>();
            _serviceAccounts = new Dictionary<string, MDWSConnection>();
        }        
    }

}
