﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shared.Model
{
    public class CommunicationTemplate
    {
        public virtual int Id { get; set; }
        public virtual string Name { get; set; }
        public virtual CommunicationType Type { get; set; }
        public virtual string Subject {get; set;}
        public virtual string Message { get; set; }
        public virtual string Recipient { get; set; } // “Patient” or “Provider” 
        public virtual int DateOffset { get; set; }
        public virtual string Medium { get; set; } // “email”, “mail”, “sms” 
        
        public virtual string TypeDisplayName 
        {
            get
            {
                switch (Type)
                {
                    case CommunicationType.PreAppointment: return "Pre Appointment";
                    case CommunicationType.PostAppointment: return "Post Appointment";
                    case CommunicationType.Cancellation: return "Cancellation";
                    case CommunicationType.WaitingList: return "Waiting List";
                    case CommunicationType.Transfer: return "Transfer";
                    default: return "Undefined";
                }
            }
        }


    }

    public enum CommunicationType { PreAppointment, PostAppointment, Cancellation, WaitingList, Transfer };

}
