﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace Shared.Model
{
    public class AppointmentType
    {
        public virtual int Id { get; set; }
        public virtual String Name { get; set; }
        public virtual AppointmentTypeCategory AppointmentTypeCategory { get; set; }
        public virtual int Duration {get; set;}
        public virtual string DSSPrimaryStopCode {get; set;}
        public virtual string DSSCreditStopCode { get; set; }
//        public virtual Section Section { get; set; }
        public virtual IList<PatientInstructions> PatientInstructions { get; set; }

        public AppointmentType()
        {
            PatientInstructions = new List<PatientInstructions>();
        }

        public void AddPatientInstructions(PatientInstructions instructions)
        {
//            instructions.AppointmentType = this;
            PatientInstructions.Add(instructions);
        }
        
        public override bool Equals(object obj)
        {
            if (obj == null || obj.GetType() != this.GetType()) return false;
            return this == ((AppointmentType)obj);
        }

        public static bool operator !=(AppointmentType x, AppointmentType y)
        {
            return !(x == y);
        }
        
        public static bool operator ==(AppointmentType x, AppointmentType y)
        {
            if ((object)x == null || (object)y == null)
                return ((object)x == null && (object)y == null);
            return (x.Id == y.Id);
        }
    }
}
