﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shared.Model
{
    public class AppointmentRequest
    {
        public virtual int Id { get; set; }
        public virtual DateTime Time { get; set; }
        public virtual DateTime? DesiredDate { get; set; }
        public virtual User CreatingUser { get; set; }
        public virtual Patient Patient { get; set; }
        public virtual Section RequestedSection { get; set; }
        public virtual Resource RequestedResource { get; set; }
        public virtual RequestMethod RequestMethod { get; set; } // (phone, email, other)
        public virtual RequestReason Reason { get; set; }
        public virtual string Notes { get; set; }
        public virtual RequestStatus Status { get; set; }
        public virtual Appointment CausingAppointment { get; set; }  // if an appointment somehow caused this request (eq this appointment was cancelled)
        public virtual Appointment ResultingAppointment { get; set; } // when an appointment is created FOR this request, store it here
        public virtual int Priority { get; set; }
    }

    public enum RequestStatus { Unknown, Pending, Complete, Cancelled};
    public enum RequestMethod { Unknown, Automatic, Phone, Email, Internet, Other };
    public enum RequestReason { Unknown, Standard, Transfer, Cancellation, WaitList };
}
