﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shared.Model
{
    public class AppointmentRelation
    {
        public virtual int Id { get; set; }
        public virtual Appointment ChildAppointment { get; set; }
        public virtual AppointmentRelationType RelationType { get; set; }

        public static string DisplayText(AppointmentRelationType appointmentRelationType)
        {
            switch (appointmentRelationType)
            {
                case AppointmentRelationType.RequiredAfter:
                    return "Required after";
                case AppointmentRelationType.RequiredBefore:
                    return "Required before";
                case AppointmentRelationType.TravelConvenience:
                    return "Travel convenience";
                case AppointmentRelationType.RescheduleOf:
                    return "Reschedule of";
                default:
                    return appointmentRelationType.ToString();
            }
        }
    }

    public enum AppointmentRelationType { Unknown, General, Followup, RescheduleOf, RequiredBefore, RequiredAfter, TravelConvenience, Recurrence }
}
