﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Shared.Model
{
    public class Appointment
    {
        public virtual int Id { get; set; }
        public virtual DateTime Time { get; set; }
        public virtual int Length { get; set; }
        public virtual AppointmentStatus Status { get; set; }
        public virtual Patient Patient { get; set; }
        public virtual string VistaId { get; set; }
        public virtual string CaldavId { get; set; }
        public virtual bool HighPriorityReschedule { get; set; }
        public virtual Section Section { get; set; }
        public virtual AppointmentType AppointmentType { get; set; }

        public virtual IList<Resource> Resources { get; set; }
        public virtual IList<AppointmentActivity> Activity { get; set; }

        public virtual IList<AppointmentRelation> ChildAppointments { get; set; }
        public virtual string TelehealthLocation { get; set; }

        public Appointment()
        {
            Status = AppointmentStatus.Unknown;
            Resources = new List<Resource>();
            Activity = new List<AppointmentActivity>();
            ChildAppointments = new List<AppointmentRelation>();
        }

        public void AddActivity(AppointmentActivity activity)
        {
//            activity.Appointment = this;
            Activity.Add(activity);
        }

        public void AddResource(Resource resource)
        {
//            var appointmentResource = new AppointmentResource() { Appointment = this, Resource = resource };
            Resources.Add(resource);
        }

        public void AddChildAppointment(Appointment child, AppointmentRelationType relationType)
        {
            var relation = new AppointmentRelation() { ChildAppointment = child, RelationType = relationType };
            ChildAppointments.Add(relation);
        }

        public override string ToString()
        {
            return String.Format("{0} {1}", this.Time.ToString(), Status);
        }

    }
        
    public enum AppointmentStatus { Unknown, Scheduled, CheckedIn, Closed, Cancelled };
}