﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Web;
using Shared.Model.Config.MDWS;

namespace MedRed.WcfService
{
    public class Startup
    {
        static string GetWebConfigItem(string itemName)
        {
            string item = ConfigurationManager.AppSettings[itemName];

            if (item == null)
                return string.Empty;
            else
                return item;
        }

        static public MDWSConfiguration LoadDefaultConfig()
        {
            // get web.config strings
            string configDB_Connectionstring = GetWebConfigItem("ConfigDB_Connectionstring");
            string baseMDWS_UriString = GetWebConfigItem("BaseMDWS_Uri");
            string mDWS_DataSourcesString = GetWebConfigItem("MDWS_DataSources");
            string baseCaldavString = GetWebConfigItem("BaseCaldav");

            //----------------------------------------------
            // create config object
            var config = new MDWSConfiguration();
            config.BaseMDWS_Url = baseMDWS_UriString;

            //----------------------------------------------
            // MDWS_ConfigDataSource is an array of JSON strings that match the class "MDWS_ConfigDataSource" below
            DataContractJsonSerializer jsonDeserializerMdws = new DataContractJsonSerializer(typeof(MDWS_ConfigDataSource[]));
            MemoryStream msMdws = new MemoryStream(System.Text.Encoding.UTF8.GetBytes(mDWS_DataSourcesString));
            // deserialise into array of objects
            MDWS_ConfigDataSource[] mdwsDataSources = (MDWS_ConfigDataSource[])jsonDeserializerMdws.ReadObject(msMdws);


            //----------------------------------------------
            // add each MDWS resource
            foreach (var s in mdwsDataSources)
            {
                config.DataSources.Add(s.Name, new DataSource { SiteID = s.SiteId, Server = s.Server, Port = s.Port });
                config.ServiceAccounts.Add(s.Name, new MDWSConnection() { SiteID = s.SiteId, AccessCode = s.AccessCode, VerifyCode = s.VerifyCode });
            }

            //----------------------------------------------
            // config DB
            config.DB_ConnectionString = configDB_Connectionstring;

            //----------------------------------------------
            // Add caldav connection
            DataContractJsonSerializer jsonDeserlializeCaldav = new DataContractJsonSerializer(typeof(Caldav_ConfigDataSource));
            MemoryStream msCaldav = new MemoryStream(System.Text.Encoding.UTF8.GetBytes(baseCaldavString));

            // deserialise into object
            Caldav_ConfigDataSource caldav = (Caldav_ConfigDataSource)jsonDeserlializeCaldav.ReadObject(msCaldav);

            // create from data loaded
            config.Caldav_Source = new Shared.Model.Config.Calendar.CalendarConfiguration()
            {
                UserName = caldav.Username,
                Password = caldav.Password
            };
            
            if (!String.IsNullOrEmpty(caldav.Uri))  
            {
                config.Caldav_Source.BaseCalendarUri = new Uri(caldav.Uri);
            }

            //----------------------------------------------
            return config;
        }

    }

    [DataContract]
    class MDWS_ConfigDataSource
    {
        [DataMember]
        internal string Name;

        [DataMember]
        internal string SiteId;

        [DataMember]
        internal string Server;

        [DataMember]
        internal string Port;

        [DataMember]
        internal string AccessCode;

        [DataMember]
        internal string VerifyCode;
    }

    [DataContract]
    class Caldav_ConfigDataSource
    {
        [DataMember]
        internal string Uri;

        [DataMember]
        internal string Username;

        [DataMember]
        internal string Password;
    }
}
