using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data.SqlClient;
using System.Diagnostics;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.ServiceModel.Web;
using System.Text;
using MedRed.Services;
using MedRed.WcfService.DTO;
using Shared.Model;
using Shared.Model.Config.MDWS;

namespace MedRed.WcfService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "Service1" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select Service1.svc or Service1.svc.cs at the Solution Explorer and start debugging.
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class Service1 : IService1
    {
        static MDWSConfiguration config = null;

        public static Factory createFactory()
        {
            if (config == null)
            {
                config = Startup.LoadDefaultConfig();
            }
            Factory factory = Factory.GetFactory(config);
            return factory;
        }

        public Collection<Service> GetServices()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().GetServices();
            }
        }

        public Collection<AppointmentTypeCategory> GetAppointmentTypeCategories(string siteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().GetAppointmentTypeCategories(siteId);
            }
        }

        public Collection<Holiday> GetHolidays()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().GetHolidays();
            }
        }

        public Collection<Site> GetSites()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSiteService().Get();
            }
        }

        public Collection<CancellationReason> GetCancellationReasons(string vistaSiteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().GetCancellationReasons(vistaSiteId);
            }
        }

        public Site GetSite(int Id)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSiteService().Get(Id);
            }
        }

        public Collection<Facility> GetFacilities(int siteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetFacilityService().GetAll(siteId);
            }
        }

        public Facility GetFacility(int Id)
        {
            using (Factory factory = createFactory())
            {

                Facility facility = factory.GetFacilityService().Get(Id);

                return facility;
            }
        }

        public Facility AddFacility(Facility facility)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetFacilityService().Add(facility);
            }
        }

        public Facility UpdateFacility(Facility facility)
        {
            using (Factory factory = createFactory())
            {

                return factory.GetFacilityService().Update(facility);
            }
        }

        public CommunicationTemplate AddUpdateFacilityCommunicationTemplate(int facilityId, CommunicationTemplate commTemplate)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetFacilityService().AddOrUpdateCommunicationTemplate(facilityId, commTemplate);
            }
        }

        public Collection<Section> GetSections(int facilityId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSectionService().GetAll(facilityId);
            }
        }

        public Section GetSection(int Id)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSectionService().Get(Id);
            }
        }

        public Section AddSection(Section section)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSectionService().Add(section);
            }
        }

        public CommunicationTemplate AddUpdateSectionCommunicationTemplate(int sectionId, CommunicationTemplate commTemplate)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSectionService().AddOrUpdateCommunicationTemplate(sectionId, commTemplate);
            }
        }

        public Site AddSite(Site site)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSiteService().Add(site);
            }
        }

        public Site GetFromVistaSiteId(string VistaSiteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSiteService().GetFromVistaSiteId(VistaSiteId);
            }
        }

        
        public bool ImportSite(string siteId)
        {
            try
            {
                using (Factory factory = createFactory())
                {
                    return factory.GetImportService().ImportSite(siteId);
                }
            }
            catch (Exception e)
            {
                return false;
            }
        }

        public bool ImportProviders(string siteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetImportService().ImportProviders(siteId);
            }
        }

        public bool CheckAndUpdate()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetImportService().CheckAndUpdate();
            }
        }

        public Section UpdateSection(Section section)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetSectionService().Update(section);
            }
        }

        public Collection<Provider> GetAllProviders()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetProviderService().Get();
            }
        }

        public Provider GetProvider(int Id)
        {
            using (Factory factory = createFactory())
            {
                var provider = factory.GetProviderService().Get(Id);
                //            provider.ProviderSites.All(ps => { ps.Provider = null; return true; });
                return provider;
            }
        }

        public Provider AddProvider(Provider provider)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetProviderService().Add(provider);
            }
        }

        public Provider UpdateProvider(Provider provider)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetProviderService().Update(provider);
            }
        }

        public Resource GetResource(int resourceId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetResourceService().Get(resourceId);
            }
        }

        public Resource AddResource(Resource resource)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetResourceService().Add(resource);
            }
        }

        public Resource UpdateResource(Resource resource)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetResourceService().Update(resource);
            }
        }

        public Collection<String> VistaQuery(string vistaSiteId, string file, string fields)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetImportService().VistaQuery(vistaSiteId, file, "", fields);
            }
        }

        public Collection<String> VistaQuery_WithIEN(string vistaSiteId, string file, string iens, string fields)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetImportService().VistaQuery(vistaSiteId, file, iens, fields);
            }
        }

        public Collection<String> VistaQuery_FindMatchingRows(string vistaSiteId, string file, string fields, int position, string searchValue)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetImportService().VistaQuery_FindMatchingRows(vistaSiteId, file, fields, position, searchValue);
            }
        }

        public Dictionary<string, string> VistaReadSpecificRecord(string vistaSiteId, string file, string ien, string fields)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetImportService().VistaReadSpecificRecord(vistaSiteId, file, ien, fields);
            }
        }

        public Patient AddPatient(Patient patient)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetPatientService().Add(patient);
            }
        }

        public Collection<PatientSearchResult> SearchPatients(string siteId, string searchParam)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetPatientService().Search(siteId, searchParam);
            }
        }

        public Patient GetPatient(PatientSearchResult patSearchResult)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetPatientService().Get(patSearchResult);
            }
        }

        public Patient GetPatientFromId(int Id)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetPatientService().Get(Id);
            }
        }


        public Appointment GetAppointment(int id)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().Get(id);
            }
        }

        public Appointment UpdateAppointment(Appointment appointment)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().Update(appointment);
            }
        }

        public bool DeleteAppointment(int id)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().Delete(id);
            }
        }

        public Appointment CreateAppointment(Appointment appointment)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().CreateAppointment(appointment);
            }
        }

        public Appointment CancelAppointment(int apptId, string cancelType, string cancelReason, string remarks)
        {
            using (Factory factory = createFactory())
            {
                var appointment = factory.GetAppointmentService().Get(apptId);
                return factory.GetAppointmentService().CancelAppointment(appointment, cancelType, cancelReason, remarks);
            }
        }

        public Appointment CheckInAppointment(int apptId)
        {
            using (Factory factory = createFactory())
            {
                var appointment = factory.GetAppointmentService().Get(apptId);
                return factory.GetAppointmentService().CheckInAppointment(appointment);
            }
        }

        public Appointment CheckOutAppointment(int apptId, string disposition)
        {
            using (Factory factory = createFactory())
            {
                var appt = factory.GetAppointmentService().Get(apptId);
                return factory.GetAppointmentService().CheckOutAppointment(appt, disposition);
            }
        }

        public Appointment CreateWalkInAppointment(Appointment appointment)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().CreateWalkInAppointment(appointment);
            }
        }

        public Appointment NoShowAppointment(int apptId)
        {
            using (Factory factory = createFactory())
            {
                var appointment = factory.GetAppointmentService().Get(apptId);
                return factory.GetAppointmentService().NoShowAppointment(appointment);
            }
        }

        public Collection<Appointment> GetAppointmentsForPatient(int patientId, DateTime start, DateTime end)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().GetForPatient(patientId, start, end);
            }
        }

        public Collection<Appointment> GetAppointmentsForResource(int resourceId, DateTime start, DateTime end)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().GetForResource(resourceId, start, end);
            }
        }

        public Collection<Appointment> GetAllRelatedAppointments(Appointment appointment)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().GetAllRelatedAppointments(appointment);
            }
        }

        public CommunicationQueueItem AddToCommunicationQueue(CommunicationQueueItem queueItem)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().AddToCommunicationQueue(queueItem);
            }
        }

        public Collection<CommunicationQueueItem> GetAllRelatedCommunications(Appointment appointment)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().GetAllRelatedCommunications(appointment);
            }
        }

        public AppointmentRequest AddAppointmentRequest(AppointmentRequest request)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().AddAppointmentRequest(request);
            }
        }

        public AppointmentRequest UpdateAppointmentRequest(AppointmentRequest request)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().UpdateAppointmentRequest(request);
            }
        }

        public Collection<AppointmentRequest> GetAppointmentRequestsForPatient(Patient patient)
        {
            using (Factory factory = createFactory())
            {
                var requests = factory.GetAppointmentService().GetAppointmentRequestsForPatient(patient);
                foreach (var request in requests)
                {
                    if (request.CreatingUser != null)
                    {
                        request.CreatingUser.Password = "";
                    }
                }

                return requests;
            }
        }

        public Collection<AppointmentRequest> GetAllOpenAppointmentRequests(Section section)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().GetAllOpenAppointmentRequests(section);
            }
        }

        public bool RestoreDBToSnapShot(string snapshotName)
        {
            //string command = "c:\\batch\\RestoreDB.bat "+snapshotName;
            //Process p = Process.Start(command);
            //if (p.WaitForExit(5 * 60 * 1000))
            //{
            //    return (p.ExitCode == 0);
            //}
            //else
            //{
            //    p.Kill();
            //    return false;
            //}
            MedRed.DataAccess.DataAccess.CloseSessionFactory();

            SqlConnection thisConnection = new SqlConnection(@"Data Source=127.0.0.1;Initial Catalog=master;Persist Security Info=True;User ID=sa;Password=password");
            thisConnection.Open();
            var sqlCommand = thisConnection.CreateCommand();

            sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
            sqlCommand.Parameters.Add(new SqlParameter("Name", snapshotName));
            sqlCommand.CommandText = "DBRestore";

            try
            {
                sqlCommand.ExecuteNonQuery();
                return true;
            }
            catch (Exception e)
            {
                return false;
            }
            finally
            {
                thisConnection.Close();                
            }
        }

        public Dictionary<DateTime, List<SlotInstance>> GetResourceAvailability(int resourceId, DateTime rangeStart, DateTime rangeEnd)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetResourceService().GetAvailability(resourceId, rangeStart, rangeEnd);
            }
        }

        public Collection<Resource> GetAllResources(int sectionId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetResourceService().GetAll(sectionId);
            }
        }

        public Collection<Resource> GetAllResourcesOfType(int sectionId, ResourceType type)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetResourceService().GetAllOfType(sectionId, type);
            }
        }


        public Collection<Appointment> GetNoShowAppointmentsForPatient(int patientId, DateTime? start, DateTime? end)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetAppointmentService().GetNoShowAppointmentsForPatient(patientId, start, end);
            }
        }


        public Room AddRoom(Room room)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetRoomService().Add(room);
            }
        }

        public Collection<Room> GetRoomsForSite(int siteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetRoomService().GetAllForSite(siteId);
            }
        }

        public Equipment AddEquipment(Equipment equipment)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetEquipmentService().Add(equipment);
            }
        }

        public Collection<Equipment> GetEquipmentForSite(int siteId)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetEquipmentService().GetAllForSite(siteId);
            }
        }


        public SpecialNeedType AddSpecialNeedType(SpecialNeedType type)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().AddSpecialNeedType(type);
            }
        }

        public Collection<SpecialNeedType> GetSpecialNeedTypes()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().GetSpecialNeedTypes();
            }
        }

        public PatientPreferenceType AddPatientPreferenceType(PatientPreferenceType type)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().AddPatientPreferenceType(type);
            }
        }

        public Collection<PatientPreferenceType> GetPatientPreferenceTypes()
        {
            using (Factory factory = createFactory())
            {
                return factory.GetNationalSystemService().GetPatientPreferenceTypes();
            }
        }

        public Patient Update(Patient patient)
        {
            using (Factory factory = createFactory())
            {
                return factory.GetPatientService().Update(patient);
            }
        }
    }
}
