﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using MedRed.Services.Interfaces;
using MedRed.WcfService.DTO;
using Shared.Model;

namespace MedRed.WcfService
{
    [ServiceContract]
    public interface IService1
    {
        [OperationContract]
        Site AddSite(Site site);

        [OperationContract]
        bool ImportSite(string siteId);

        [OperationContract]
        bool ImportProviders(string siteId);

        [OperationContract]
        bool CheckAndUpdate();

        [OperationContract]
        Collection<Service> GetServices();

        [OperationContract]
        Collection<AppointmentTypeCategory> GetAppointmentTypeCategories(string vistaSiteId);

        [OperationContract]
        Collection<Holiday> GetHolidays();

        [OperationContract]
        Collection<Site> GetSites();

        [OperationContract]
        Site GetSite(int Id);

        [OperationContract]
        Collection<CancellationReason> GetCancellationReasons(string vistaSiteId);

        [OperationContract]
        Site GetFromVistaSiteId(string VistaSiteId);

        [OperationContract]
        Collection<Facility> GetFacilities(int siteId);

        [OperationContract]
        Facility GetFacility(int Id);

        [OperationContract]
        Facility AddFacility(Facility facility);

        [OperationContract]
        Facility UpdateFacility(Facility facility);

        [OperationContract]
        CommunicationTemplate AddUpdateFacilityCommunicationTemplate(int facilityId, CommunicationTemplate commTemplate);

        [OperationContract]
        Collection<Section> GetSections(int facilityId);

        [OperationContract]
        Section GetSection(int Id);

        [OperationContract]
        Section AddSection(Section section);

        [OperationContract]
        Section UpdateSection(Section section);

        [OperationContract]
        CommunicationTemplate AddUpdateSectionCommunicationTemplate(int sectionId, CommunicationTemplate commTemplate);
        
        [OperationContract]
        Collection<Provider> GetAllProviders();

        [OperationContract]
        Provider GetProvider(int Id);

        [OperationContract]
        Provider AddProvider(Provider provider);

        [OperationContract]
        Provider UpdateProvider(Provider provider);

        [OperationContract]
        Resource GetResource(int resourceId);

        [OperationContract]
        Collection<Resource> GetAllResources(int sectionId);

        [OperationContract]
        Collection<Resource> GetAllResourcesOfType(int sectionId, ResourceType type);

        [OperationContract]
        Dictionary<DateTime, List<SlotInstance>> GetResourceAvailability(int resourceId, DateTime rangeStart, DateTime rangeEnd);

        [OperationContract]
        Resource AddResource(Resource resource);

        [OperationContract]
        Resource UpdateResource(Resource resource);

        [OperationContract]
        Patient AddPatient(Patient patient);

        [OperationContract]
        Collection<PatientSearchResult> SearchPatients(string siteId, string searchParam);

        [OperationContract]
        Patient GetPatient(PatientSearchResult patSearchResult);

        [OperationContract]
        Patient GetPatientFromId(int Id);

        [OperationContract]
        Appointment GetAppointment(int id);

        [OperationContract]
        Appointment UpdateAppointment(Appointment appointment);

        [OperationContract]
        bool DeleteAppointment(int id);

        [OperationContract]
        Appointment CreateAppointment(Appointment appointment);

        [OperationContract]
        Appointment CancelAppointment(int apptId, string cancelType, string cancelReason, string remarks);

        [OperationContract]
        Appointment CheckInAppointment(int apptId);

        [OperationContract]
        Appointment CheckOutAppointment(int apptId, string disposition);

        [OperationContract]
        Appointment CreateWalkInAppointment(Appointment appointment);

        [OperationContract]
        Appointment NoShowAppointment(int apptId);

        [OperationContract]
        Collection<Appointment> GetAppointmentsForPatient(int patientId, DateTime start, DateTime end);

        [OperationContract]
        Collection<Appointment> GetAppointmentsForResource(int resourceId, DateTime start, DateTime end);

        [OperationContract]
        Collection<Appointment> GetAllRelatedAppointments(Appointment appointment);

        [OperationContract]
        CommunicationQueueItem AddToCommunicationQueue(CommunicationQueueItem queueItem);

        [OperationContract]
        Collection<CommunicationQueueItem> GetAllRelatedCommunications(Appointment appointment);

        [OperationContract]
        AppointmentRequest AddAppointmentRequest(AppointmentRequest request);

        [OperationContract]
        AppointmentRequest UpdateAppointmentRequest(AppointmentRequest request);

        [OperationContract]
        Collection<AppointmentRequest> GetAppointmentRequestsForPatient(Patient patient);

        [OperationContract]
        Collection<AppointmentRequest> GetAllOpenAppointmentRequests(Section section);
        
        [OperationContract]
        Collection<String> VistaQuery(string vistaSiteId, string file, string fields);

        [OperationContract]
        Collection<String> VistaQuery_WithIEN(string vistaSiteId, string file, string iens, string fields);

        [OperationContract]
        Collection<String> VistaQuery_FindMatchingRows(string vistaSiteId, string file, string fields, int position, string searchValue);

        [OperationContract]
        Dictionary<string, string> VistaReadSpecificRecord(string vistaSiteId, string file, string ien, string fields);

        [OperationContract]
        bool RestoreDBToSnapShot(string snapshotName);

        [OperationContract]
        Collection<Appointment> GetNoShowAppointmentsForPatient(int patientId, DateTime? start, DateTime? end);

        [OperationContract]
        Room AddRoom(Room room);

        [OperationContract]
        Collection<Room> GetRoomsForSite(int siteId);

        [OperationContract]
        Equipment AddEquipment(Equipment equipment);

        [OperationContract]
        Collection<Equipment> GetEquipmentForSite(int siteId);

        [OperationContract]
        SpecialNeedType AddSpecialNeedType(SpecialNeedType type);

        [OperationContract]
        Collection<SpecialNeedType> GetSpecialNeedTypes();

        [OperationContract]
        PatientPreferenceType AddPatientPreferenceType(PatientPreferenceType type);

        [OperationContract]
        Collection<PatientPreferenceType> GetPatientPreferenceTypes();

        [OperationContract]
        Patient Update(Patient patient);

    }
}
