﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using Shared.Model;

namespace MedRed.Services.Utils
{
    public class PasswordHelper
    {
        public static void SetUserPassword(ref User user, string password)
        {
            if (string.IsNullOrEmpty(user.Salt))
            {
                user.Salt = CreateSalt();
            }
            user.Password = hashPassword(user, password);
        }

        public static bool CheckPassword(User user, string password)
        {
            var hashedPassword = hashPassword(user, password);
            return String.Equals(user.Password, hashedPassword);
        }

        private static string hashPassword(User user, string password)
        {
            var hash = Hash(Encoding.UTF8.GetBytes(password), Encoding.UTF8.GetBytes(user.Salt));
            return Encoding.UTF7.GetString(hash);
        }

        static int offset=1;
        private static string CreateSalt()
        {
            Random r = new Random((int)(DateTime.Now.Ticks*offset++));
            var val = r.NextDouble();
            return val.ToString();
        }

        private static byte[] Hash(byte[] value, byte[] salt)
        {
            byte[] saltedValue = value.Concat(salt).ToArray();

            return new SHA256Managed().ComputeHash(saltedValue);
        }
    }
}
