﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model;

namespace MedRed.Services.Utils
{
    public class AppointmentHelper
    {
        static public bool PerformAutomaticAppointmentCancelActions(Factory factory, Appointment appointment, string reason)
        {
            // cancel this appointment
            factory.GetAppointmentService().CancelAppointment(appointment, "C", "13", reason);

            // process communication template
            CommunicationQueueItem queueItem = CommunicationHelper.PrepareCommunication(appointment, CommunicationType.Cancellation);

            // send out notification
            if (queueItem != null)
            {
                factory.GetAppointmentService().AddToCommunicationQueue(queueItem);
                var apptActivity = new AppointmentActivity()
                {
                    Time = DateTime.UtcNow,
                    ActivityType = ActivityType.CommunicationSent,
                    ActivityReason = reason,
                };
                appointment.AddActivity(apptActivity);
                factory.GetAppointmentService().Update(appointment);
            }

            // create new appointment request
            var apptRequest = new AppointmentRequest();
            apptRequest.CausingAppointment = appointment;
            apptRequest.CreatingUser = factory.CurrentUser;
            apptRequest.DesiredDate = null;
            apptRequest.Notes = "Existing appointment was automatically cancelled due to following reason: " + reason;
            apptRequest.Patient = appointment.Patient;
            apptRequest.RequestedSection = appointment.Section;
            apptRequest.RequestMethod = RequestMethod.Automatic;
            apptRequest.Reason = RequestReason.Cancellation;
            apptRequest.Status = RequestStatus.Pending;
            apptRequest.Time = DateTime.UtcNow;

            factory.GetAppointmentService().AddAppointmentRequest(apptRequest);

            foreach (var appt in appointment.ChildAppointments)
            {
                if (appt.ChildAppointment.Status == AppointmentStatus.Scheduled)
                {
                    PerformAutomaticAppointmentCancelActions(factory, appt.ChildAppointment, reason);
                }
            }

            return true;
        }
    }
}
