﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using Shared.Model;
using MedRed.Services.Interfaces;

namespace MedRed.Services.ServiceImpl
{
    class UIService : BaseService, IUIService
    {
        public UIService(Factory factory) :
            base(factory)
        {
        }

        public Collection<UIPage> GetPages()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var UIPages = from s in session.Query<UIPage>()
                            select s;

                transaction.Commit();
                return new Collection<UIPage>(UIPages.ToList());
            }
        }

        public UIPage GetPage(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var UIPage = session.Get<UIPage>(id);

                transaction.Commit();
                return UIPage;
            }
        }

        public UIPage AddPage(UIPage UIPage)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(UIPage);

                transaction.Commit();
                return UIPage;
            }
        }

        public UIPage UpdatePage(UIPage UIPage)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(UIPage);

                transaction.Commit();
                return UIPage;
            }
        }

        public bool DeletePage(int id)
        {
            var obj = GetPage(id);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                if (obj != null)
                {
                    session.Delete(obj);
                }
                transaction.Commit();
                return true;
            }
        }

        public Collection<UIMenu> GetMenus()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var UIPages = from s in session.Query<UIMenu>()
                              select s;

                transaction.Commit();
                return new Collection<UIMenu>(UIPages.ToList());
            }
        }

        public UIMenu GetMenu(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var UIPage = session.Get<UIMenu>(id);

                transaction.Commit();
                return UIPage;
            }
        }

        public UIMenu AddMenu(UIMenu UIPage)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(UIPage);

                transaction.Commit();
                return UIPage;
            }
        }

        public UIMenu UpdateMenu(UIMenu UIPage)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(UIPage);

                transaction.Commit();
                return UIPage;
            }
        }

        public bool DeleteMenu(int id)
        {
            var obj = GetMenu(id);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                if (obj != null)
                {
                    session.Delete(obj);
                }
                transaction.Commit();
                return true;
            }
        }
    }
}
