﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using MedRed.DataAccess;
using NHibernate.Linq;
using Shared.Model;
using Shared.Model.Config.MDWS;

namespace MedRed.Services.ServiceImpl
{
    class SiteService : BaseService, ISiteService
    {
        public SiteService(Factory factory) :
            base(factory)
        {
        }

        public Collection<Site> Get()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var sites = from s in session.Query<Site>()
                            select s;

                transaction.Commit();
                return new Collection<Site>(sites.ToList());
            }
        }

        public Site Get(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var site = session.Get<Site>(id);

                transaction.Commit();
                return site;
            }
        }

        public Site GetFromVistaSiteId(string VistaSiteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var site = from s in session.Query<Site>()
                           where s.VistaSiteId == VistaSiteId
                           select s;

                transaction.Commit();
                if (site != null && site.Count() > 0)
                    return site.First();
                return null;
            }
        }

        public Site Add(Site site)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(site);

                transaction.Commit();
                return site;
            }
        }

        public Site Update(Site site)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(site);

                transaction.Commit();
                return site;
            }
        }

        public bool Delete(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var site = Get(id);

                if (site != null)
                {
                    session.Delete(site);
                }
                transaction.Commit();
                return true;
            }
        }
    }
}
