﻿using System;
using System.Collections.Generic;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using System.Collections.ObjectModel;


namespace MedRed.Services.ServiceImpl
{
    class RoomService : BaseService, IRoomService
    {
        public RoomService(Factory factory) :
            base(factory)
        {
        }
        public Collection<Room> Get()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var rooms = from s in session.Query<Room>()
                            select s;

                transaction.Commit();
                return new Collection<Room>(rooms.ToList());
            }
        }

        public Collection<Room> GetAllForSite(int siteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var rooms = from s in session.Query<Room>()
                            where s.Site.Id == siteId
                            select s;

                transaction.Commit();
                return new Collection<Room>(rooms.ToList());
            }
        }

        public Room Get(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var room = session.Get<Room>(id);

                transaction.Commit();
                return room;
            }
        }

        public Room Add(Room room)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(room);

                transaction.Commit();
                return room;
            }
        }

        public Room Update(Room room)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(room);

                transaction.Commit();
                return room;
            }
        }

        public bool Delete(int id)
        {
            throw new NotImplementedException();
        }
    }
}
