﻿using System;
using System.Collections.Generic;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using System.Collections.ObjectModel;


namespace MedRed.Services.ServiceImpl
{
    class ProviderService : BaseService, IProviderService
    {
        public ProviderService(Factory factory) :
            base(factory)
        {
        }

        public Collection<Provider> Get()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var resources = from s in session.Query<Provider>()
                                select s;

                transaction.Commit();
                return new Collection<Provider>(resources.ToList());
            }
        }

        public Collection<Provider> GetAllForSite(int siteId)
        {
            Site site = ParentFactory.GetSiteService().Get(siteId);
            if (site == null)
                throw new ArgumentException("Invalid Site Id passed in");

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var resources = from s in session.Query<Provider>()
                                where s.ProviderSites.ContainsKey(site.VistaSiteId)
                                select s;

                transaction.Commit();
                return new Collection<Provider>(resources.ToList());
            }
        }

        public Provider Get(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var provider = session.Get<Provider>(id);

                transaction.Commit();
                return provider;
            }
        }

        public Provider Add(Provider provider)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(provider);

                transaction.Commit();
                return provider;
            }
        }

        public Provider Update(Provider provider)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(provider);

                transaction.Commit();
                return provider;
            }
        }

        public bool Delete(int id)
        {
            throw new NotImplementedException();
        }


        public Provider Get(string vistaSiteId, string duz)
        {
            Provider provider = null;

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var providers = from p in session.Query<Provider>()
//                                where p.ProviderSites.Any(s => s.VistaSiteId == vistaSiteId && s.DUZ == duz)
                                where p.ProviderSites[vistaSiteId] == duz
                               select p;

                transaction.Commit();
                if (providers.Count() > 0)
                    provider = providers.First();
            }

            return provider;
        }


        public Provider GetByNPI(string NPI)
        {
            if (string.IsNullOrEmpty(NPI))
                return null;
            Provider provider = null;

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var providers = from p in session.Query<Provider>()
                                where p.NPI == NPI
                                select p;

                transaction.Commit();
                if (providers.Count() > 0)
                    provider = providers.First();
            }

            return provider;
        }

        public Provider GetBySSN(string SSN)
        {
            if (string.IsNullOrEmpty(SSN))
                return null;
            Provider provider = null;

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var providers = from p in session.Query<Provider>()
                                where p.Person.SSN == SSN
                                select p;

                transaction.Commit();
                if (providers.Count() > 0)
                    provider = providers.First();
            }

            return provider;
        }
    }
}
