﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model;
using Shared.Model.Config.MDWS;

namespace MedRed.Services.ServiceImpl
{
    class NationalSystemService : BaseService, INationalSystemService
    {
        public NationalSystemService(Factory factory) :
            base(factory)
        {
        }

        public Service AddService(Service service)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(service);
                transaction.Commit();
            }
            return service;
        }

        public Collection<Service> GetServices()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var services = from s in session.Query<Service>()
                               select s;

                transaction.Commit();
                if (services != null)
                    return new Collection<Service>(services.ToList());
                return new Collection<Service>();
            }
        }

        public AppointmentTypeCategory AddAppointmentTypeCategory(AppointmentTypeCategory appTypeCat)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(appTypeCat);
                transaction.Commit();
            }
            return appTypeCat;
        }

        public CancellationReason AddCancellationReason(CancellationReason cancelReason)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(cancelReason);
                transaction.Commit();
            }
            return cancelReason;
        }

        public Collection<AppointmentTypeCategory> GetAppointmentTypeCategories(string vistaSiteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var apptTypes = from a in session.Query<AppointmentTypeCategory>()
                                where a.VistaSiteId == vistaSiteId
                                select a;

                transaction.Commit();
                if (apptTypes != null)
                    return new Collection<AppointmentTypeCategory>(apptTypes.ToList());
                return new Collection<AppointmentTypeCategory>(); ;
            }
        }

        public Holiday AddHoliday(Holiday holiday)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(holiday);
                transaction.Commit();
            }
            return holiday;
        }

        public Collection<Holiday> GetHolidays()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var holidays = from h in session.Query<Holiday>()
                               select h;

                transaction.Commit();
                if (holidays != null)
                    return new Collection<Holiday>(holidays.ToList());
                return new Collection<Holiday>(); 
            }
        }

        public Collection<Holiday> GetHolidaysBetween(DateTime start, DateTime end)
        {
            DateTime startDate = start.Date;
            DateTime endDate = end.Date.AddDays(1);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var holidays = from h in session.Query<Holiday>()
                               where (h.Date >= startDate &&
                                     h.Date < endDate)
                               select h;

                transaction.Commit();
                if (holidays != null)
                    return new Collection<Holiday>(holidays.ToList());
                return new Collection<Holiday>();
            }
        }

        public PatientPreferenceType AddPatientPreferenceType(PatientPreferenceType type)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(type);
                transaction.Commit();
            }
            return type;
        }

        public Collection<PatientPreferenceType> GetPatientPreferenceTypes()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var types = from h in session.Query<PatientPreferenceType>()
                               select h;

                transaction.Commit();
                if (types != null)
                    return new Collection<PatientPreferenceType>(types.ToList());
                return new Collection<PatientPreferenceType>(); ;
            }
        }

        public SpecialNeedType AddSpecialNeedType(SpecialNeedType type)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(type);
                transaction.Commit();
            }
            return type;
        }

        public Collection<SpecialNeedType> GetSpecialNeedTypes()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var types = from h in session.Query<SpecialNeedType>()
                               select h;

                transaction.Commit();
                if (types != null)
                    return new Collection<SpecialNeedType>(types.ToList());
                return new Collection<SpecialNeedType>(); ;
            }
        }

        public Collection<CancellationReason> GetCancellationReasons(string vistaSiteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var reasons = from h in session.Query<CancellationReason>()
                              where h.VistaSiteId == vistaSiteId
                              select h;

                transaction.Commit();
                if (reasons != null)
                    return new Collection<CancellationReason>(reasons.ToList());
                return new Collection<CancellationReason>(); ;
            }
        }

        public StopCode AddStopCode(StopCode stopCode)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(stopCode);
                transaction.Commit();
            }
            return stopCode;
        }

        public Collection<StopCode> GetStopCodes(string vistaSiteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var stopCodes = from h in session.Query<StopCode>()
                              where h.VistaSiteId == vistaSiteId
                              select h;

                transaction.Commit();
                if (stopCodes != null)
                    return new Collection<StopCode>(stopCodes.ToList());
                return new Collection<StopCode>(); ;
            }
        }

        public Collection<StopCode> GetStopCodes(string vistaSiteId, RestrictionType restrictType)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var stopCodes = from h in session.Query<StopCode>()
                                where h.VistaSiteId == vistaSiteId &&
                                (h.RestrictionType == restrictType || h.RestrictionType == RestrictionType.Either)
                                select h;

                transaction.Commit();
                if (stopCodes != null)
                    return new Collection<StopCode>(stopCodes.ToList());
                return new Collection<StopCode>(); ;
            }
        }

    }
}
