﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using System.Collections.ObjectModel;


namespace MedRed.Services.ServiceImpl
{
    class ImportService : BaseService, IImportService
    {
        public ImportService(Factory factory) :
            base(factory)
        {
        }

        public bool CheckAndUpdate()
        {
            // get all active sites (how to configure only ones we're responsible for?)
            bool success = true;
//            success = success && ValidateServiceAccount("333");
            success = success && ValidateServiceAccount("444");
//            success = success && ValidateServiceAccount("557");
//            success = success && ImportSite("333");
//            success = success && ImportProviders("333");
            success = success && ImportSite("444");
            success = success && ImportProviders("444");
//            success = success && ImportSite("557");
//            success = success && ImportProviders("557");
            return success;
        }

        public bool ImportSite(string vistaSiteID)
        {
            var mdws = GetMDWSDAO(vistaSiteID);

            var vistaSite = mdws.GetSite(vistaSiteID);
            
            if (vistaSite == null)
                return false;

            var timezone = mdws.getTimeZone(vistaSiteID);
            string timeZoneId = timezone.Id;

            var siteService = ParentFactory.GetSiteService();
            // if already exits, update, otherwise, add
            var dbSite = siteService.GetFromVistaSiteId(vistaSiteID);
            if (dbSite != null)
            {
                // update
                dbSite.TimeZoneId = timeZoneId;
                dbSite.Name = vistaSite.Name;
                dbSite.Phone = vistaSite.Phone;
                if (dbSite.Address == null)
                    dbSite.Address = new Address();
                dbSite.Address.Street1 = vistaSite.Address.Street1;
                dbSite.Address.Street2 = vistaSite.Address.Street2;
                dbSite.Address.Street3 = vistaSite.Address.Street3;
                dbSite.VistaSiteId = vistaSite.VistaSiteId;

                siteService.Update(dbSite);
            }
            else
            {
                vistaSite.TimeZoneId = timeZoneId;
                dbSite = siteService.Add(vistaSite);
            }

            var facilityService = ParentFactory.GetFacilityService();
            // get all facilities
            var vistaFacilities = mdws.GetFacilities();
            var dbFacilities = facilityService.GetAll(dbSite.Id).ToList();

            // for each
            foreach (var facility in vistaFacilities)
            {
                // if already exists, update, otherwise add
                if (!dbFacilities.Exists(s => String.Equals(s.Name, facility.Name)))
                {
                    facility.Site = new Site() { Id = dbSite.Id };
                    facility.Hours = "0800-1600";
                    facilityService.Add(facility);
                }
            }
            
            var natSysService = ParentFactory.GetNationalSystemService();
            // get all services
            var vistaSpecialties = mdws.GetServices();
            var dbSpecialties = natSysService.GetServices().ToList();

            // update existing list of services
            foreach (var specialty in vistaSpecialties)
            {
                if (!dbSpecialties.Exists(s => String.Equals(s.Name,specialty.Name)))
                {
                    natSysService.AddService(specialty);
                }
            }

            // get all appointment type categories
            var vistaAppTypeCategories = mdws.GetAppointmentTypeCategories();
            var dbAppTypeCategories = natSysService.GetAppointmentTypeCategories(vistaSiteID).ToList();

            // update existing list
            foreach (var category in vistaAppTypeCategories)
            {
                if (!dbAppTypeCategories.Exists(c => String.Equals(c.Name,category.Name)))
                {
                    natSysService.AddAppointmentTypeCategory(category);
                }
            }

            // get all cancellation reasons
            var vistaCancellationReasons = mdws.getCancellationReasons();
            var dbCancellationReasons = natSysService.GetCancellationReasons(vistaSiteID).ToList();

            // update existing list
            foreach (var reason in vistaCancellationReasons)
            {
                if (!dbCancellationReasons.Exists(c => String.Equals(c.Name, reason.Name)))
                {
                    natSysService.AddCancellationReason(reason);
                }
            }

            // get all stop codes
            var vistaStopCodes = mdws.getStopCodes();
            var dbStopCodes = natSysService.GetStopCodes(vistaSiteID).ToList();

            // update existing list
            foreach (var stopCode in vistaStopCodes)
            {
                if (!dbStopCodes.Exists(c => String.Equals(c.Name, stopCode.Name)))
                {
                    natSysService.AddStopCode(stopCode);
                }
            }

            // get all holidays
            var vistaHolidays = mdws.GetHolidays();
            var dbHolidays = natSysService.GetHolidays().ToList();

            // update existing list
            foreach (var holiday in vistaHolidays)
            {
                if (!dbHolidays.Exists(h => h.Date.Date == holiday.Date.Date))
                {
                    natSysService.AddHoliday(holiday);
                }
            }

            return true;
        }

        public bool ImportProviders(string vistaSiteID)
        {
            var mdws = GetMDWSDAO(vistaSiteID);

            //Dictionary<string, string> values = new Dictionary<string,string>();
            //values[".01"] = "WEATHER";
            //values["2"] = "B";
            //// add cancellation reasons
            //var result = mdws.create(values, "409.2", "");

            //values[".01"] = "CLINIC CANCELLED";
            //result = mdws.create(values, "409.2", "");


            //// delete all patients
            //var vistaResults = mdws.VistaQuery("2", "", "@;.01");

            //foreach (var result in vistaResults)
            //{
            //    string[] values = result.Split('^');

            //    try
            //    {
            //        mdws.delete("2", values[0]);
            //    }
            //    catch (Exception)
            //    {
            //    }
            //}

            // load all providers
            var providerService = ParentFactory.GetProviderService();

            var vistaProviders = mdws.GetAllProviders();

            foreach (var provider in vistaProviders)
            {
                string duz = provider.GetDUZForVistASite(vistaSiteID);

                // Delete the providers
                //if (!provider.Person.FirstName.ToUpper().Equals("MEDRED") &&
                //    !provider.Person.LastName.ToUpper().Equals("MEDRED") &&
                //    (!provider.Person.LastName.ToUpper().Equals("MANAGER") && !provider.Person.FirstName.ToUpper().Equals("SYSTEM")) &&
                //    provider.ProviderSites[vistaSiteID] != "1")
                //{

                //    try
                //    {
                //        mdws.delete("200", duz);
                //    }
                //    catch (Exception)
                //    {
                //        int i = 0;
                //    }
                //}
                //continue;

                if (String.IsNullOrEmpty(duz))
                {
                    throw new Exception("Providers can not be missing a DUZ");
                }
                // find provider by DUZ
                var localProvider = providerService.Get(vistaSiteID, duz);
                if (localProvider != null)
                {
                    // already present, move on
                    continue;
                }

                // find provider by NPI
                localProvider = providerService.GetByNPI(provider.NPI);
                if (localProvider == null)
                {
                    // didn't find my NPI, lets also try by SSN
                    localProvider = providerService.GetBySSN(provider.Person.SSN);
                }
                if (localProvider != null)
                {         
                    // we found provider. Lets make sure they don't already have a DUZ for this site
                    string localDUZ = localProvider.GetDUZForVistASite(vistaSiteID);
                    if (!String.IsNullOrEmpty(localDUZ))
                    {
                        throw new Exception("Provider has local DUZ, but wasn't found by Get(site, duz)");
                    }
                    localProvider.AddProviderSite(vistaSiteID, duz);
                    providerService.Update(localProvider);
                    continue;
                }

                if (localProvider == null)
                {
                    // Haven't found them, Add provider to system
                    var fullProvider = mdws.LoadProvider(duz);
                    providerService.Add(fullProvider);
                }
            }

            return true;
        }

        public bool ValidateServiceAccount(string vistaSiteId)
        {
            try
            {
               var mdws = GetMDWSDAO(vistaSiteId);
               mdws.GetSite(vistaSiteId);
               return true;
            }
            catch (Exception)
            {
                return false;
            }
        }

        public Collection<String> VistaQuery(string vistaSiteId, string file, string IENs, string fields)
        {
            var mdws = GetMDWSDAO(vistaSiteId);
            return new Collection<string>(mdws.VistaQuery(file, IENs, fields));
        }

        public Collection<String> VistaQuery_FindMatchingRows(string vistaSiteId, string file, string fields, int position, string searchValue)
        {
            var mdws = GetMDWSDAO(vistaSiteId);
            return new Collection<string>(mdws.VistaQuery_FindMatchingRows(file, fields, position, searchValue));
        }

        public Dictionary<string, string> VistaReadSpecificRecord(string vistaSiteId, string file, string ien, string fields)
        {
            var mdws = GetMDWSDAO(vistaSiteId);
            return mdws.VistaQuery_SpecificRecord(file, ien, fields);
        }

    }
}
