﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model;
using Shared.Model.Config.MDWS;
using Auditing;


namespace MedRed.Services.ServiceImpl
{
    class FacilityService : BaseService, IFacilityService
    {
        public FacilityService(Factory factory) :
            base(factory)
        {
        }

        public Collection<Facility> GetAll(int siteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var facilities = from f in session.Query<Facility>()
                                 where f.Site.Id == siteId
                                 select f;

                transaction.Commit();
                return new Collection<Facility>(facilities.ToList());
            }
        }

        public Facility Get(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var facility = session.Get<Facility>(id);
                    //from f in session.Query<Facility>()
                    //           where f.Id == id
                    //           select f;

                transaction.Commit();

                return facility;
            }
        }

        public Facility Add(Facility facility)
        {
            if (facility.Site == null)
            {
                throw new Exception("Facilities must be associated with a site");
            }
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(facility);

                transaction.Commit();

                int siteId = 0;
                if (facility.Site != null)
                    siteId = facility.Site.Id;

                Auditing.Logger.Log(
                Auditing.LogType.Information,
                siteId,
                Auditing.ObjectType.Facility,
                Auditing.FacilityFunction.FacilityCreated,
                facility.Id,
                facility.Name,
                Auditing.Status.Success,
                false,
                "");
                

                return facility;
            }
        }

        public Facility Update(Facility facility)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(facility);

                transaction.Commit();
                return facility;
            }
        }

        public bool Delete(int id)
        {
            var facility = Get(id);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {

                if (facility != null)
                {
                    session.Delete(facility);
                }
                transaction.Commit();
                return true;
            }
        }

        public CommunicationTemplate AddOrUpdateCommunicationTemplate(int facilityId, CommunicationTemplate communicationTemplate)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var facility = Get(facilityId);

                var existingTemplate = facility.CommunicationTemplates.Where(c => c.Id == communicationTemplate.Id);
                if (existingTemplate != null && existingTemplate.Count() > 0)
                {
                    var copyOfList = existingTemplate.ToList();
                    copyOfList.All(x => facility.CommunicationTemplates.Remove(x));
                }
                facility.CommunicationTemplates.Add(communicationTemplate);
                session.SaveOrUpdate(facility);
                transaction.Commit();

                //TODO AUDITING

                return communicationTemplate;
            }
        }

        public bool DeleteCommunicationTemplate(int facilityId, CommunicationTemplate communicationTemplate)
        {
            bool somethingRemoved = false;

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var facility = Get(facilityId);

                var existingTemplate = facility.CommunicationTemplates.Where(c => c.Id == communicationTemplate.Id);
                if (existingTemplate != null && existingTemplate.Count() > 0)
                {
                    var copyOfList = existingTemplate.ToList();
                    copyOfList.All(x => facility.CommunicationTemplates.Remove(x));
                    somethingRemoved = true;
                }
                session.SaveOrUpdate(facility);
                transaction.Commit();
                return somethingRemoved;
            }
        }
    }
}
