﻿using System;
using System.Collections.Generic;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using System.Collections.ObjectModel;


namespace MedRed.Services.ServiceImpl
{
    class EquipmentService : BaseService, IEquipmentService
    {
        public EquipmentService(Factory factory) :
            base(factory)
        {
        }

        public Collection<Equipment> Get()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var collection = from s in session.Query<Equipment>()
                                 select s;

                transaction.Commit();
                return new Collection<Equipment>(collection.ToList());
            }
        }

        public Collection<Equipment> GetAllForSite(int siteId)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var collection = from s in session.Query<Equipment>()
                                 where s.Site.Id == siteId
                                select s;

                transaction.Commit();
                return new Collection<Equipment>(collection.ToList());
            }
        }

        public Equipment Get(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var equipment = session.Get<Equipment>(id);

                transaction.Commit();
                return equipment;
            }
        }

        public Equipment Add(Equipment equipment)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(equipment);

                transaction.Commit();
                return equipment;
            }
        }

        public Equipment Update(Equipment equipment)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(equipment);

                transaction.Commit();
                return equipment;
            }
        }

        public bool Delete(int id)
        {
            throw new NotImplementedException();
        }
    }
}
