﻿using System;
using System.Collections.Generic;
using System.Linq;
using NHibernate.Linq;
using System.Text;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using MedRed.Services.Utils;
using System.Collections.ObjectModel;
using Shared.Model.UserRoles;


namespace MedRed.Services.ServiceImpl
{
    class AccountService : BaseService, IAccountService
    {
        public AccountService(Factory factory) :
            base(factory)
        {
        }

        public User LogOn(string username, string password)
        {
            User user = null;
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {

                var users = from u in session.Query<User>()
                           where u.Username == username
                           select u;

                transaction.Commit();
                if (users != null && users.Count() > 0)
                    user = users.First();
            }

            if (user != null && PasswordHelper.CheckPassword(user, password))
                return user;

            return null;
        }

        public Collection<User> GetUsers()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var users = from u in session.Query<User>()                                 
                                 select u;

                transaction.Commit();
                return new Collection<User>(users.ToList());
            }
        }
        
        public User GetUser(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var user = session.Get<User>(id);

                transaction.Commit();

                return user;
            }
        }

        public User GetUserFromUsername(string username)
        {
            User user = null;
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var users = from u in session.Query<User>()
                            where u.Username == username
                            select u;

                transaction.Commit();
                user = users.FirstOrDefault();
            }
      
            return user;      
        }


        public User AddUser(User user)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(user);

                transaction.Commit();
            }
            return user;
        }

        public User UpdateUser(User user)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(user);

                transaction.Commit();
            }
            return user;
        }

        public bool DeleteUser(int id)
        {
            var user = GetUser(id);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {

                if (user != null)
                {
                    session.Delete(user);
                }
                transaction.Commit();
                return true;
            }
        }

        public Collection<Role> GetAllRoles()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var roles = from u in session.Query<Role>()
                            select u;

                transaction.Commit();
                return new Collection<Role>(roles.ToList());
            }
        }

        public Role GetRole(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var role = session.Get<Role>(id);

                transaction.Commit();

                return role;
            }
        }

        public Role AddRole(Role role)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(role);

                transaction.Commit();
            }
            return role;
        }

        public Role UpdateRole(Role role)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(role);

                transaction.Commit();
            }
            return role;
        }

        public bool DeleteRole(int id)
        {
            var role = GetRole(id);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                if (role != null)
                {
                    session.Delete(role);
                }
                transaction.Commit();
                return true;
            }
        }

        public Collection<Shared.Model.UserRoles.Action> GetAllActions()
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var actions = from u in session.Query<Shared.Model.UserRoles.Action>()
                            select u;

                transaction.Commit();
                return new Collection<Shared.Model.UserRoles.Action>(actions.ToList());
            }
        }

        public Shared.Model.UserRoles.Action GetAction(int id)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                var action = session.Get<Shared.Model.UserRoles.Action>(id);

                transaction.Commit();

                return action;
            }
        }

        public Shared.Model.UserRoles.Action AddAction(Shared.Model.UserRoles.Action action)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.Save(action);

                transaction.Commit();
            }
            return action;
        }

        public Shared.Model.UserRoles.Action UpdateAction(Shared.Model.UserRoles.Action action)
        {
            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                session.SaveOrUpdate(action);

                transaction.Commit();
            }
            return action;
        }

        public bool DeleteAction(int id)
        {
            var action = GetAction(id);

            using (var session = MedRed.DataAccess.DataAccess.OpenSession())
            using (var transaction = session.BeginTransaction())
            {
                if (action != null)
                {
                    session.Delete(action);
                }
                transaction.Commit();
                return true;
            }
        }
    }
}
