﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using Shared.Model;

namespace MedRed.Services.Interfaces
{
    public interface ISectionService 
    {
        Collection<Section> GetAll(int facilityId);
        Section Get(int id);
        Section Add(Section section);
        Section Update(Section section);
        bool Delete(int id);

        CommunicationTemplate AddOrUpdateCommunicationTemplate(int sectionId, CommunicationTemplate communicationTemplate);
        bool DeleteCommunicationTemplate(int sectionId, CommunicationTemplate communicationTemplate);
        AppointmentType AddOrUpdateAppointmentType(int sectionId, AppointmentType appointmentType);
        bool DeleteAppointmentType(int sectionId, AppointmentType appointmentType);

//        Collection<Resource> GetResourcesUsingAppointmentType(AppointmentType appointmentType);
    }
}
