﻿using System;
using System.Collections.Generic;
using Shared.Model;
using System.Collections.ObjectModel;

namespace MedRed.Services.Interfaces
{
    public interface IResourceService 
    {
        Collection<Resource> GetAll(int sectionId);
        Collection<Resource> GetAllOfType(int sectionId, ResourceType type);
        Resource Get(int id);
        Resource Add(Resource resource);
        Resource Update(Resource resource);
        bool Delete(int id);

        Dictionary<DateTime, List<SlotInstance>> GetCapacity(int resourceId, DateTime rangeStart, DateTime rangeEnd, AppointmentType appointmentType = null);
        Dictionary<DateTime, List<SlotInstance>> GetAvailability(int resourceId, DateTime rangeStart, DateTime rangeEnd, AppointmentType appointmentType = null);

        Dictionary<DateTime, List<SlotInstance>> GetGroupAppointmentSlots(int resourceId, DateTime rangeStart, DateTime rangeEnd, AppointmentType appointmentType = null);

        Dictionary<DateTime, List<SlotInstance>> GetAvailability(Collection<int> resourceIds, DateTime rangeStart, DateTime rangeEnd, AppointmentType appointmentType = null);

        Collection<Resource> FindAlternateAvailableProviders(Appointment appointment);
        Collection<Resource> FindAlternateAvailableGroupProviders(Appointment appointment);

        //_ResourceOHSD LoadCapacity(string resourceId, DateTime rangeStart, DateTime rangeEnd);

        //Collection<_TimeSlot> GetResourceAvailability(string resourceId, DateTime rangeStart, DateTime rangeEnd);
        //Collection<string> GetAllSpecialties(string siteId);

        // types can be Clinic, Doctor, Room, ...
        //Collection<Resource> FindByName(string siteId, ResourceType resourceType, string searchParam);
        //Collection<Resource> FindBySpecialty(string siteId, ResourceType resourceType, string searchParam);

        //Collection<Appointment> GetAppointments(int resourceId, DateTime rangeStart, DateTime rangeEnd);
    }
}