﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Shared.Model;
using System.Collections.ObjectModel;

namespace MedRed.Services.Interfaces
{
    public interface IPatientService
    {
        Collection<Patient> Get();
        Patient Get(int id);
        Patient Add(Patient patient);
        Patient Update(Patient patient);
        bool Delete(int id);

        Patient GetFullDetails(string vistaSiteId, int id);

        Collection<PatientSearchResult> Search(string siteId, string searchParam);
        Patient Get(PatientSearchResult patSearchResult);
        Patient Get(string vistaSiteId, string dfn);

        Collection<Appointment> GetAppointments(string siteId, string dfn, DateTime rangeStart, DateTime rangeEnd);
        //Collection<Appointment> GetAppointments(int patientId, DateTime rangeStart, DateTime rangeEnd);

        //bool MakeAppointment(int patientId, Collection<Resource> resources, DateTime appointmentTime);

        Provider GetPrimaryCareProvider(int id);
    }
}
