﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using Shared.Model;

namespace MedRed.Services.Interfaces
{
    public interface INationalSystemService
    {
        Service AddService(Service service);
        Collection<Service> GetServices();

        AppointmentTypeCategory AddAppointmentTypeCategory(AppointmentTypeCategory appTypeCat);
        Collection<AppointmentTypeCategory> GetAppointmentTypeCategories(string vistaSiteId);

        CancellationReason AddCancellationReason(CancellationReason cancellationReason);
        Collection<CancellationReason> GetCancellationReasons(string vistaSiteId);

        StopCode AddStopCode(StopCode stopCode);
        Collection<StopCode> GetStopCodes(string vistaSiteId);
        Collection<StopCode> GetStopCodes(string vistaSiteId, RestrictionType restrictType);

        Holiday AddHoliday(Holiday holiday);
        Collection<Holiday> GetHolidays();
        Collection<Holiday> GetHolidaysBetween(DateTime start, DateTime end);

        PatientPreferenceType AddPatientPreferenceType(PatientPreferenceType type);
        Collection<PatientPreferenceType> GetPatientPreferenceTypes();

        SpecialNeedType AddSpecialNeedType(SpecialNeedType type);
        Collection<SpecialNeedType> GetSpecialNeedTypes();
    }
}
