﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using Shared.Model;

namespace MedRed.Services.Interfaces
{
    public interface IAppointmentService
    {
        Appointment Get(int id);
        Appointment Update(Appointment appointment);
        bool Delete(int id);

//        Appointment DoAction(Appointment appointment, AppointmentAction action, string reason = "");
        Appointment CreateAppointment(Appointment appointment);
        Appointment CreateWalkInAppointment(Appointment appointment);
        Appointment CheckInAppointment(Appointment appointment);
        Appointment CheckOutAppointment(Appointment appointment, string disposition);
        Appointment NoShowAppointment(Appointment appointment);
        Appointment CancelAppointment(Appointment appointment, string cancelType, string cancelReason, string remarks);

        Appointment CreateRecurringAppointments(Appointment appointment, Recur recur);

//        string GetAppointmentVistaStatus(Appointment appointment);

        Collection<Appointment> GetForPatient(int patientId, DateTime? start, DateTime? end);
        Collection<Appointment> GetNoShowAppointmentsForPatient(int patientId, DateTime? start, DateTime? end);

        Collection<Appointment> GetForResource(int resourceId, DateTime? start, DateTime? end, AppointmentStatus status = AppointmentStatus.Unknown);
        Collection<Appointment> GetAllForAppointmentType(AppointmentType apptType, DateTime? start, DateTime? end, AppointmentStatus status);

        Collection<Appointment> GetAllRelatedAppointments(Appointment appointment);

        CommunicationQueueItem AddToCommunicationQueue(CommunicationQueueItem queueItem);
        CommunicationQueueItem AddToCommunicationQueue(CommunicationTemplate template, Appointment appointment);
        CommunicationQueueItem AddToCommunicationQueue(CommunicationTemplate template, AppointmentRequest appointmentRequest);
        Collection<CommunicationQueueItem> GetAllRelatedCommunications(Appointment appointment);
        Collection<CommunicationQueueItem> GetAllRelatedCommunications(AppointmentRequest appointmentRequest);

        AppointmentRequest AddAppointmentRequest(AppointmentRequest request);
        AppointmentRequest UpdateAppointmentRequest(AppointmentRequest request);
        Collection<AppointmentRequest> GetAppointmentRequestsForPatient(Patient patient);
        Collection<AppointmentRequest> GetAllOpenAppointmentRequests(Section section);
    }

    public enum AppointmentAction { Create, WalkIn, CheckIn, CheckOut, NoShow, Cancel, Reschedule };
}
