﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using Shared.Model;
using Shared.Model.UserRoles;

namespace MedRed.Services.Interfaces
{
    public interface IAccountService
    {
        User LogOn(string username, string password);

        Collection<User> GetUsers();
        User GetUser(int id);
        User GetUserFromUsername(string userName);
        User AddUser(User user);
        User UpdateUser(User user);
        bool DeleteUser(int id);

        Collection<Role> GetAllRoles();
        Role GetRole(int id);
        Role AddRole(Role role);
        Role UpdateRole(Role role);
        bool DeleteRole(int id);

        Collection<Shared.Model.UserRoles.Action> GetAllActions();
        Shared.Model.UserRoles.Action GetAction(int id);
        Shared.Model.UserRoles.Action AddAction(Shared.Model.UserRoles.Action action);
        Shared.Model.UserRoles.Action UpdateAction(Shared.Model.UserRoles.Action action);
        bool DeleteAction(int id);

    }
}
